﻿---
title: Endpoints
description: The Endpoints page allows administrators to view and manage endpoints that are running the Elastic Defend integration. The Endpoints list displays all...
url: https://www.elastic.co/docs/solutions/security/manage-elastic-defend/endpoints
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Endpoints
The Endpoints page allows administrators to view and manage endpoints that are running the [Elastic Defend integration](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend).
<admonition title="Requirements">
  - Fleet must be enabled in a Kibana space for administrative actions to function correctly.
  - You must have the **Endpoint List** [privilege](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-feature-privileges) or the appropriate user role to access this feature.
</admonition>


## Endpoints list

The **Endpoints** list displays all hosts running Elastic Defend and their relevant integration details. Endpoints appear in chronological order, with newly added endpoints at the top.
![Endpoints page](https://www.elastic.co/docs/solutions/images/security-endpoints-pg.png)

The Endpoints list provides the following data:
- **Endpoint**: The system hostname. Click the link to display [endpoint details](#endpoint-details) in a flyout.
- **Agent Status**: The current [status](/docs/reference/fleet/monitor-elastic-agent#view-agent-status) of the Elastic Agent.
  <note>
  Not all Elastic Agent statuses in Fleet correspond to the statuses in the Elastic Security app. For example, an `unenrolled` Elastic Agent in Fleet shows as `offline` in the Elastic Security app.
  </note>
- **Policy:** The name of the associated integration policy when the agent was installed. Click the link to display the [integration policy details](#integration-policy-details) page.
- **Policy status:** Indicates whether the integration policy was successfully applied. Click the link to view [policy status](#policy-status) response details in a flyout.
- **OS**: The host’s operating system.
- **IP address**: All IP addresses associated with the hostname.
- **Version**: The Elastic Agent version currently running.
- **Last active**: A date and timestamp of the last time the Elastic Agent was active.
- **Actions**: Select the context menu (**…**) to do the following:
  - **Isolate host**: [Isolate the host](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/isolate-host) from your network, blocking communication until the host is released.
- **Respond**: Open the [response console](https://www.elastic.co/docs/solutions/security/endpoint-response-actions) to perform response actions directly on the host.
- **View response actions history**: View a [history of response actions](#response-action-history-tab) performed on the host.
- **View host details**: View host details on the **Hosts** page in the Elastic Security app.
- **View agent policy**: View the agent policy in Fleet.
- **View agent details**: View Elastic Agent details and activity logs in Fleet.
- **Reassign agent policy**: Change the [agent policy](/docs/reference/fleet/agent-policy#apply-a-policy) assigned to the host in Fleet.


### Endpoint details

Click any link in the **Endpoint** column to display host details in a flyout. You can also use the **Take Action** menu button to perform the same actions as those listed in the Actions context menu, such as isolating the host, viewing host details, and viewing or reassigning the agent policy.
![Endpoint details flyout](https://www.elastic.co/docs/solutions/images/security-host-flyout.png)


### Response actions history

The endpoint details flyout also includes the **Response actions history** tab, which provides a log of the [response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions) performed on the endpoint, such as isolating a host or terminating a process. You can use the tools at the top to filter the information displayed in this view. Refer to [Response actions history](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/response-actions-history) for more details.
![Response actions history with a few past actions](https://www.elastic.co/docs/solutions/images/security-response-actions-history-endpoint-details.png)


### Integration policy details

To view the integration policy page, click the link in the **Policy** column. If you are viewing host details, you can also click the **Policy** link on the flyout.
On this page, you can view and configure endpoint protection and event collection settings. In the upper-right corner are Key Performance Indicators (KPIs) that provide current endpoint status. If you need to update the policy, make changes as appropriate, then click the **Save** button to apply the new changes.
<note>
  Users must have permission to read/write to Fleet APIs to make changes to the configuration.
</note>

![Integration page](https://www.elastic.co/docs/solutions/images/security-integration-pg.png)

Users who have unique configuration and security requirements can select **Show advanced settings** to configure the policy to support advanced use cases. Hover over each setting to view its description.
<note>
  Advanced settings are not recommended for most users.
</note>

![Integration page](https://www.elastic.co/docs/solutions/images/security-integration-advanced-settings.png)


### Policy status

The status of the integration policy appears in the **Policy status** column and displays one of the following:
- `Success`: The policy was applied successfully.
- `Warning` or `Partially Applied`: The policy is pending application, or the policy was not applied in its entirety.
  <note>
  In some cases, actions taken on the endpoint may fail during policy application, but these cases are not critical failures - meaning there may be a failure, but the endpoints are still protected. In this case, the policy status will display as "Partially Applied."
  </note>
- `Failure`: The policy did not apply correctly, and endpoints are not protected.
- `Unknown`: The user interface is waiting for the API response to return, or, in rare cases, the API returned an undefined error or value.

For more details on what’s causing a policy status, click the link in the **Policy status** column and review the details flyout. Expand each section and subsection to display individual responses from the agent.
<tip>
  If you need help troubleshooting a configuration failure, refer to [Troubleshoot Elastic Defend](/docs/troubleshoot/security/elastic-defend#ts-unhealthy-agent) and [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).
</tip>

![Config status details](https://www.elastic.co/docs/solutions/images/security-config-status.png)


### Filter endpoints

To filter the Endpoints list, use the search bar to enter a query using [Kibana Query Language (KQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql). To refresh the search results, click **Refresh**.
![filter endpoints](https://www.elastic.co/docs/solutions/images/security-filter-endpoints.png)

<note>
  The date and time picker on the right side of the page allows you to set a time interval to automatically refresh the Endpoints list — for example, to check if new endpoints were added or deleted.
</note>