﻿---
title: Endpoint protection rules
description: Endpoint protection rules are prebuilt rules designed to help you manage and respond to alerts generated by Elastic Endpoint, the installed component...
url: https://www.elastic.co/docs/solutions/security/manage-elastic-defend/endpoint-protection-rules
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Endpoint protection rules
Endpoint protection rules are [prebuilt rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/install-manage-elastic-prebuilt-rules) designed to help you manage and respond to alerts generated by Elastic Endpoint, the installed component that performs Elastic Defend's threat monitoring and prevention. These rules include the Endpoint Security (Elastic Defend) rule as well as additional detection and prevention rules for different Elastic Defend protection features.
<important>
  To receive Elastic Endpoint alerts, you must install Elastic Agent and the Elastic Defend integration  on your hosts (refer to [Install Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend)).
</important>

When endpoint protection rules are triggered, Elastic Endpoint alerts are displayed as detection alerts in the Elastic Security app. The detection alert name is taken from the Elastic Endpoint alert message and overwrites the prebuilt rule name in the Alerts table. For example, for malware protection, the following Elastic Endpoint alerts are displayed as detection alerts:
- Malware Prevention Alert
- Malware Detection Alert


## Endpoint Security rule

The [Endpoint Security (Elastic Defend)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/elastic_endpoint_security) rule automatically creates an alert from all incoming Elastic Endpoint alerts.
<note>
  When you install Elastic prebuilt rules, the Endpoint Security (Elastic Defend) rule is enabled by default.
</note>


## Feature-specific protection rules

The following endpoint protection rules give you more granular control over how you handle the generated alerts. These rules are tailored for each of Elastic Defend's endpoint protection features—malware, ransomware, memory threats, and malicious behavior. Enabling these rules allows you to configure more specific actions based on the protection feature and whether the malicious activity was prevented or detected.
- [Behavior - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/elastic_endpoint_security_behavior_detected)
- [Behavior - Prevented - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/elastic_endpoint_security_behavior_prevented)
- [Malicious File - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/execution_elastic_malicious_file_detected)
- [Malicious File - Prevented - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/execution_elastic_malicious_file_prevented)
- [Memory Threat - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/defense_evasion_elastic_memory_threat_detected)
- [Memory Threat - Prevented - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/defense_evasion_elastic_memory_threat_prevented)
- [Ransomware - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/impact_elastic_ransomware_detected)
- [Ransomware - Prevented - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/impact_elastic_ransomware_prevented)

<note>
  If you choose to use the feature-specific protection rules, we recommend that you disable the Endpoint Security (Elastic Defend) rule, as using both will result in duplicate alerts.
</note>

To use these rules, you need to manually enable them from the **Rules** page in the Elastic Security app. Follow the instructions for [installing and enabling Elastic prebuilt rules](/docs/solutions/security/detect-and-alert/install-manage-elastic-prebuilt-rules#load-prebuilt-rules).

## Endpoint security exception handling

All endpoint protection rules share a common exception list called the Endpoint Security Exception List. This ensures that if you switch between using the Endpoint Security (Elastic Defend) rule and the feature-specific protection rules, your existing [Elastic Endpoint exceptions](/docs/solutions/security/detect-and-alert/add-manage-exceptions#endpoint-rule-exceptions) continue to apply.