﻿---
title: Elastic Endpoint self-protection features
description: Elastic Endpoint, the installed component that performs Elastic Defend's threat monitoring and prevention, protects itself against users and attackers...
url: https://www.elastic.co/docs/solutions/security/manage-elastic-defend/elastic-endpoint-self-protection-features
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Endpoint self-protection features
Elastic Endpoint, the installed component that performs Elastic Defend's threat monitoring and prevention, protects itself against users and attackers that may try to interfere with its functionality. Protection features are consistently enhanced to prevent attackers who may attempt to use newer, more sophisticated tactics to interfere with the Elastic Endpoint. Self-protection is enabled by default when Elastic Endpoint installs on supported platforms, listed below.
Self-protection is enabled on the following 64-bit Windows versions:
- Windows 8.1
- Windows 10
- Windows 11
- Windows Server 2012 R2
- Windows Server 2016
- Windows Server 2019
- Windows Server 2022

Self-protection is also enabled on the following macOS versions:
- macOS 10.15 (Catalina)
- macOS 11 (Big Sur)
- macOS 12 (Monterey)

<note>
  Other Windows and macOS variants (and all Linux distributions) do not have self-protection.
</note>

For Elastic Stack version >= 7.11.0, self-protection defines the following permissions:
- Users — even Administrator/root — **cannot** delete Elastic Endpoint files (located at `c:\Program Files\Elastic\Endpoint` on Windows, and `/Library/Elastic/Endpoint` on macOS).
- Users **cannot** terminate the Elastic Endpoint program or service.
- Administrator/root users **can** read Elastic Endpoint's files. On Windows, the easiest way to read Elastic Endpoint files is to start an Administrator `cmd.exe` prompt. On macOS, an Administrator can use the `sudo` command.
- Administrator/root users **can** stop the Elastic Agent's service. On Windows, run the `sc stop "Elastic Agent"` command. On macOS, run the `sudo launchctl stop elastic-agent` command.