﻿---
title: Automatic troubleshooting
description: Automatic troubleshooting helps you identify and resolve issues that could prevent Elastic Defend from working as intended. It provides actionable insights...
url: https://www.elastic.co/docs/solutions/security/manage-elastic-defend/automatic-troubleshooting
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2, Preview from 9.0 to 9.1
---

# Automatic troubleshooting
Automatic troubleshooting helps you identify and resolve issues that could prevent Elastic Defend from working as intended. It provides actionable insights into the following common problem areas:
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> **Policy responses**: Detect warnings or failures in Elastic Defend’s integration policies.
- **Third-party antivirus (AV) software**: Identify installed third-party antivirus (AV) products that may conflict with Elastic Defend.

This helps you resolve configuration errors, address incompatibilities, and ensure that your hosts remain protected.
<admonition title="Requirements">
  To use this feature, you need:
  - In serverless, a project with the Security Analytics Complete [feature tier](https://www.elastic.co/pricing/serverless-security).
  - The **Automatic Troubleshooting: Read** or **Automatic Troubleshooting: All** security [sub-feature privilege](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-feature-privileges).
    <note>
    In Elastic Stack 9.0.0, this privilege is called **Endpoint Insights**.
    </note>
  - A working [LLM connector](https://www.elastic.co/docs/explore-analyze/ai-features/llm-guides/llm-connectors) for AI Assistant.
</admonition>


## Troubleshoot policy issues

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

Elastic Defend's integration policy statuses indicate whether protections are applied successfully to your hosts. Warnings or failures in these policies can weaken your security posture. Automatic troubleshooting helps you detect any issues and suggests remediation steps.
<admonition title="Requirements">
  To use this functionality, you need to enable [AI Assistant Knowledge Base](https://www.elastic.co/docs/solutions/security/ai/ai-assistant-knowledge-base).
</admonition>


### Scan your hosts for policy issues

1. Find **Endpoints** in the navigation menu or use the global search field.
2. Click on an endpoint to open its details flyout.
3. Under **Automatic Troubleshooting**, select an LLM connector, or [add](https://www.elastic.co/docs/explore-analyze/ai-features/llm-guides/llm-connectors) a new one.
4. If you don't already have AI Assistant Knowledge Base enabled, click **Setup Knowledge Base**.
5. Once Knowledge Base is enabled, click **Scan**. After a brief processing period, any detected warnings or failures in policy responses will appear under **Insights**.


### Resolve policy issues

After a scan has completed, automatic troubleshooting suggests recommended next steps for each policy issue. These may include adjusting specific Elastic Defend policy settings or reviewing conflicting host configurations. Where available, click **Learn more** to the right of a result to open Elastic documentation, which provides more context and guidance for resolving the issue.

## Identify antivirus software on your hosts

Third-party antivirus software installed on your hosts can interfere with Elastic Defend. To mitigate issues with running third-party AV alongside Elastic Defend, you first have to identify which AV is present.
After you’ve installed Elastic Defend on one or more hosts, you can use automatic troubleshooting to check whether your endpoints have third-party AV software installed. Using the same kinds of large language model (LLM) connectors as Elastic AI Assistant, automatic troubleshooting can analyze file event logs from your hosts to determine whether antivirus software is present. From there, you can address any incompatibilities to make sure your endpoints are protected.

### Scan your hosts for AV software

1. Find **Endpoints** in the navigation menu or use the global search field.
2. Click on an endpoint to open its details flyout.
3. Under **Automatic Troubleshooting**, select an LLM connector, or [add](https://www.elastic.co/docs/explore-analyze/ai-features/llm-guides/llm-connectors) a new one.
4. Click **Scan**. After a brief processing period, any detected AV products will appear under **Insights**.


### Resolve incompatibilities

After a scan has completed, you can click the **Create trusted app** button to the right of a result to quickly add the associated AV program to Elastic Defend's trusted applications list. If the button is not clickable, you don’t have the [required privilege](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications).
<important>
  If you plan to use Elastic Defend alongside third-party AV software, we recommend you that you both [allowlist Elastic Endpoint in your AV](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/allowlist-elastic-endpoint-in-third-party-antivirus-apps) and [make the AV a trusted application](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications).
</important>