﻿---
title: Allowlist Elastic Endpoint in third-party antivirus apps
description: Third-party antivirus (AV) applications may identify the expected behavior of Elastic Endpoint—the installed component that performs Elastic Defend's...
url: https://www.elastic.co/docs/solutions/security/manage-elastic-defend/allowlist-elastic-endpoint-in-third-party-antivirus-apps
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Allowlist Elastic Endpoint in third-party antivirus apps
<note>
  If you use other antivirus (AV) software along with Elastic Defend, you may need to add the other system as a trusted application in the Elastic Security app. Refer to [*Trusted applications*](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications) for more information.
</note>

Third-party antivirus (AV) applications may identify the expected behavior of Elastic Endpoint—the installed component that performs Elastic Defend's threat monitoring and prevention—as a potential threat. Add Elastic Endpoint's digital signatures and file paths to your AV software’s allowlist to ensure Elastic Endpoint continues to function as intended. We recommend you allowlist both the file paths and digital signatures, if applicable.
<note>
  Your AV software may refer to allowlisted processes as process exclusions, ignored processes, or trusted processes. It is important to note that file, folder, and path-based exclusions/exceptions are distinct from trusted applications and will not achieve the same result. This page explains how to ignore actions taken by processes, not how to ignore the files that spawned those processes.
</note>


## Allowlist Elastic Endpoint on Windows

File paths:
- ELAM driver: `c:\Windows\system32\drivers\ElasticElam.sys`
- Driver: `c:\Windows\system32\drivers\elastic-endpoint-driver.sys`
- Executable: `c:\Program Files\Elastic\Endpoint\elastic-endpoint.exe`
  <note>
  The executable runs as `elastic-endpoint.exe`.
  </note>

Digital signatures:
- `Elasticsearch, Inc.`
- `Elasticsearch B.V.`

For additional information about allowlisting on Windows, refer to [Trusting Elastic Defend in other software](https://github.com/elastic/endpoint/blob/main/PerformanceIssues-Windows.md#trusting-elastic-defend-in-other-software).

## Allowlist Elastic Endpoint on macOS

File paths:
- System extension (recursive directory structure): `/Applications/ElasticEndpoint.app/`
  <note>
  The system extension runs as `co.elastic.systemextension`.
  </note>
- Executable: `/Library/Elastic/Endpoint/elastic-endpoint.app/Contents/MacOS/elastic-endpoint`
  <note>
  The executable runs as `elastic-endpoint`.
  </note>

Digital signatures:
- Authority/Developer ID Application: `Elasticsearch, Inc (2BT3HPN62Z)`
- Team ID: `2BT3HPN62Z`


## Allowlist Elastic Endpoint on Linux

File path:
- Executable: `/opt/Elastic/Endpoint/elastic-endpoint`
  <note>
  The executable runs as `elastic-endpoint`.
  </note>