﻿---
title: Visual event analyzer
description: Elastic Security allows any event detected by Elastic Endpoint or supported third-party integrations to be analyzed using a process-based visual analyzer,...
url: https://www.elastic.co/docs/solutions/security/investigate/visual-event-analyzer
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Visual event analyzer
Elastic Security allows any event detected by Elastic Endpoint or supported third-party integrations to be analyzed using a process-based visual analyzer, which shows a graphical timeline of processes that led up to the alert and the events that occurred immediately after. Examining events in the visual event analyzer is useful to determine the origin of potentially malicious activity and other areas in your environment that may be compromised. It also enables security analysts to drill down into all related hosts, processes, and other events to aid in their investigations.
<tip>
  If you’re experiencing performance degradation, you can [exclude cold and frozen tier data](/docs/solutions/security/get-started/configure-advanced-settings#exclude-cold-frozen-tiers) from analyzer queries. This setting is only available for the Elastic Stack.
</tip>


## Find events to analyze

You can visualize events from the following sources:
- Elastic Defend integration
- Sysmon data collected through Winlogbeat
- Third-party integrations:
  - [CrowdStrike](https://www.elastic.co/docs/reference/integrations/crowdstrike) (Falcon logs collected through Event Stream or FDR)
- [SentinelOne Cloud Funnel](https://www.elastic.co/docs/reference/integrations/sentinel_one_cloud_funnel)
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> [Microsoft Defender for Endpoint](https://www.elastic.co/docs/reference/integrations/microsoft_defender_endpoint)

In KQL, this translates to any event with the `agent.type` set to:
- `endpoint`
- `winlogbeat` with `event.module` set to `sysmon`
- `filebeat` with `event.module` set to `crowdstrike`
- `filebeat` with `event.module` set to `sentinel_one_cloud_funnel`
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> `filebeat` with `event.module` set to `microsoft_defender_endpoint`

<applies-to>Elastic Stack: Generally available since 9.2</applies-to> The visual analyzer also supports analyzing `event.kind: "alert"` events from third-party integrations. To view these events, your role must have `read` privileges for the `alerts-security.alerts-*` indices.
To find events that can be visually analyzed:
1. First, display a list of events by doing one of the following:
   - Find **Hosts** in the main menu, or search for `Security/Explore/Hosts` by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then select the **Events** tab. A list of all your hosts' events appears at the bottom of the page.
- Find **Alerts** in the main menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then scroll down to the Alerts table.
2. Filter events that can be visually analyzed by entering one of the following queries in the KQL search bar, then selecting **Enter**:
   - `agent.type:"endpoint" and process.entity_id :*`
- `agent.type:"winlogbeat" and event.module: "sysmon" and process.entity_id : *`
- `agent.type:"filebeat" and event.module: "crowdstrike" and process.entity_id : *`
- `agent.type:"filebeat" and event.module: "sentinel_one_cloud_funnel" and process.entity_id : *`
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> `agent.type:"filebeat" and event.module: "microsoft_defender_endpoint" and process.entity_id : *`
   <note>
   <applies-to>Elastic Stack: Generally available since 9.2</applies-to> To specifically filter for alert-kind events from third-party integrations, add `event.kind:"alert"`. For example:
   `agent.type:"filebeat" and event.module:"microsoft_defender_endpoint" and event.kind:"alert" and process.entity_id:*`
   </note>
3. Events that can be visually analyzed are denoted by a cubical **Analyze event** icon. Select this option to open the event in the visual analyzer. The event analyzer is accessible from the **Hosts**, **Alerts**, and **Timelines** pages, as well as the alert details flyout.
   <note>
   Events that cannot be analyzed will not have the **Analyze event** option available. This might occur if the event has incompatible field mappings.
   </note>
   ![analyze event button](https://www.elastic.co/docs/solutions/images/security-analyze-event-button.png)
   <tip>
   You can also analyze events from [Timelines](https://www.elastic.co/docs/solutions/security/investigate/timeline).
   </tip>


## Visual event analyzer UI

Within the visual analyzer, each cube represents a process, such as an executable file or network event. In the analyzer, you can:
- Zoom in and out of the Analyzer Graph view using the slider
- Click and drag around the Analyzer Graph view to explore the hierarchy of all process relationships
- Observe child process events that spawned from the parent process
- Determine how much time passed between each process
- Identify all events related to each process

Use the following icons to perform more actions:
- To understand what fields were used to create the process, select the **Process Tree** icon (`info`) to show the schema that created the Analyzer Graph view. The fields included are:
  - `SOURCE`: Indicates the data source—for example, `endpoint` or `winlogbeat`
- `ID`: Event field that uniquely identifies a node
- `EDGE`: Event field that indicates the relationship between two nodes
- Click the **Legend** icon (`node`) to show the state of each process node.
- Select a different data view (`index_settings`) to further filter the alert’s related events.
- Use the time filter (`calendar`) to analyze the event within a specific time range. By default, the selected time range matches that of the table from which you opened the alert.
- Click the list icon (`editor_unordered_list`) to open the preview analyzer panel. This displays a list of all processes related to the event, starting with the event chain’s first process. The **Analyzed Event**—the event you selected to analyze from the events list or Timeline—is highlighted with a light blue outline around the cube.

![visual event analyzer](https://www.elastic.co/docs/solutions/images/security-visual-event-analyzer.png)


## Process and event details

To learn more about each related process, select the process in the preview analyzer panel or the Analyzer Graph view. The preview analyzer panel then displays process details such as:
- The number of events associated with the process
- The timestamp of when the process was executed
- The file path of the process within the host
- The `process-pid`
- The user name and domain that ran the process
- Any other relevant process information
- Any associated alerts

![process details](https://www.elastic.co/docs/solutions/images/security-process-details.png)

When you first select a process, it appears in a loading state. If loading data for a given process fails, click **Reload `{{process-name}}`** beneath the process to reload the data.
Access event details by selecting that event’s URL at the top of the process details view or choosing one of the event pills in the Analyzer Graph view. Events are categorized based on the `event.category` value.
When you select an `event.category` pill (for example, **_x_ file** or **_x_ registry**), all the events within that category are listed in the preview analyzer panel. To display more details about a specific event, select it from the list.
<note>
  - You must have the appropriate [Elastic Stack](https://www.elastic.co/pricing) subscription or [Serverless project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings) to examine alerts associated with events.
  - There is no limit to the number of events that can be associated with a process.
</note>

To examine alerts associated with the event, select the alert pill (**_x_ alert**). The preview analyzer panel lists the total number of associated alerts, ordered from oldest to newest. Each alert shows the type of event that produced it (`event.category`), the event timestamp (`@timestamp`), and rule that generated the alert (`kibana.alert.rule.name`). Click on the rule name to open the alert’s details.
In the example screenshot, the analyzed event (`sdclt.exe`) generated three alerts. The preview analyzer panel displays basic information about each one.
![alert pill](https://www.elastic.co/docs/solutions/images/security-alert-pill.png)