﻿---
title: Use placeholder fields in Osquery queries
description: Instead of hard-coding alert and event values into Osquery queries, you can use placeholder fields to dynamically pass this data into queries. Placeholder...
url: https://www.elastic.co/docs/solutions/security/investigate/use-placeholder-fields-in-osquery-queries
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Use placeholder fields in Osquery queries
Instead of hard-coding alert and event values into Osquery queries, you can use placeholder fields to dynamically pass this data into queries. Placeholder fields function like parameters. You can use placeholder fields to build flexible and reusable queries.
Placeholder fields work in single queries or query packs. They’re also supported in the following features:
- [Live queries](https://www.elastic.co/docs/solutions/security/investigate/run-osquery-from-alerts)
- [Osquery Response Actions](https://www.elastic.co/docs/solutions/security/investigate/add-osquery-response-actions)
- [Investigation guides using Osquery queries](https://www.elastic.co/docs/solutions/security/investigate/run-osquery-from-investigation-guides)


## Placeholder field syntax and requirements

Placeholder fields use [mustache syntax](http://mustache.github.io/) and must be wrapped in double curly brackets (`{{example.field}}`). You can use any field within an event or alert document as a placeholder field.
Queries with placeholder fields can only run against alerts or events. Otherwise, they will lack the necessary values and the query status will be `error`.

### Example query with a placeholder field

The following query uses the `{{host.name}}` placeholder field:
```sql
SELECT * FROM os_version WHERE name = {{host.os.name}}
```

When you run the query, the value that’s stored in the alert or event’s `host.name` field will be transferred to the `{{host.os.name}}` placeholder field.