﻿---
title: Timeline
description: Use Timeline as your workspace for investigations and threat hunting. You can add alerts from multiple indices to a Timeline to facilitate advanced investigations...
url: https://www.elastic.co/docs/solutions/security/investigate/timeline
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Timeline
Use Timeline as your workspace for investigations and threat hunting. You can add alerts from multiple indices to a Timeline to facilitate advanced investigations.
You can drag or send fields of interest to a Timeline to create the desired query. For example, you can add fields from tables and histograms on the **Overview**, **Alerts**, **Hosts**, and **Network** pages, as well as from other Timelines. Alternatively, you can add a query directly in Timeline by expanding the [query builder](#narrow-expand) and clicking **+ Add field**.
![example Timeline with several events](https://www.elastic.co/docs/solutions/images/security-timeline-ui-updated.png)

In addition to Timelines, you can create and attach Timeline templates to [detection rules](https://www.elastic.co/docs/solutions/security/detect-and-alert). Timeline templates allow you to define the source event fields used when you investigate alerts in Timeline. You can select whether the fields use predefined values or values retrieved from the alert. For more information, refer to [Timeline templates](https://www.elastic.co/docs/solutions/security/investigate/timeline-templates).

## Grant access to Timeline

You can control access to Timeline by setting the [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) for the **Timeline** feature under **Security**.

## Create new or open existing Timeline

To make a new Timeline, choose one of the following:
- Find **Timelines** in the main menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then click **Create new Timeline**.
- Go to the Timeline bar (which is at the bottom of most pages), click the ![Add new button](https://www.elastic.co/docs/solutions/images/security-add-new-timeline-button.png "title") button, then click **Create new Timeline template**.
- From an open Timeline or Timeline template, click **New** → **New Timeline**.

To open an existing Timeline, choose one of the following:
- Go to the Timelines page, then click a Timeline’s title.
- Go to the Timeline bar, click the ![Add new button](https://www.elastic.co/docs/solutions/images/security-add-new-timeline-button.png "title") button, then click **Open Timeline**.
- From an open Timeline or Timeline template, click **Open**, then select the appropriate Timeline.

To avoid losing your changes, you must save the Timeline before moving to a different Elastic Security app page. If you change an existing Timeline, you can use the **Save as new timeline** toggle to make a new copy of the Timeline without overwriting the original one.
<tip>
  Click the star icon (![Favorite icon](https://www.elastic.co/docs/solutions/images/security-favorite-icon.png "title")) to favorite your Timeline and quickly find it later.
</tip>


## View and refine Timeline results

You can select whether Timeline displays detection alerts and other raw events, or just alerts. By default, Timeline displays both raw events and alerts. To hide raw events and display alerts only:
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> Select the `Security solution alerts` data view.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.1</applies-to> Click **Data view** to the left of the KQL query bar, then select **Show only detection alerts**.


## Inspect an event or alert

To further inspect an event or detection alert, click the **View details** button. A flyout with event or [alert details](https://www.elastic.co/docs/solutions/security/detect-and-alert/view-detection-alert-details) appears.

## Configure Timeline event context and display

Many types of events automatically appear in preconfigured views that provide relevant contextual information, called **Event renderers**. All event renderers are turned off by default. To turn them on, use the **Event renderers** toggle at the top of the results pane. To only turn on specific event renderers, click the gear (![Customize event renderer button](https://www.elastic.co/docs/solutions/images/security-customize-event-renderers.png "title")) icon next to the toggle, and select the ones you want enabled. Close the **Customize event renderers** pane when you’re done. Your changes are automatically applied to Timeline.
![example timeline with the event renderer highlighted](https://www.elastic.co/docs/solutions/images/security-timeline-ui-renderer.png)

The example above displays the Flow event renderer, which highlights the movement of data between its source and destination. If you see a particular part of the rendered event that interests you, you can drag it up to the drop zone below the query bar for further investigation.
You can also modify a Timeline’s display in other ways:
- [Add and remove fields](#add-remove-timeline-fields) from Timeline
- Create [runtime fields](https://www.elastic.co/docs/solutions/security/get-started/create-runtime-fields-in-elastic-security) and display them in the Timeline
- Reorder and resize columns
- Copy a column name or values to a clipboard
- Change how the name, value, or description of a field are displayed in Timeline
- View the Timeline in full screen mode
- Add or delete [notes](https://www.elastic.co/docs/solutions/security/investigate/notes) attached to alerts, events, or Timeline
- Pin interesting events to the Timeline


## Add and remove fields from Timeline

The Timeline table shows fields that are available for alerts and events in the selected data view. You can modify the table to display fields that interest you. Use the sidebar to search for specific fields or scroll through it to find fields of interest. Fields that you select display as columns in the table.
To add a field from the sidebar, hover over it, and click the **Add field as a column** button (![Add a field as a column button](https://www.elastic.co/docs/solutions/images/security-add-field-button.png "title")), or drag and drop the field into the table. To remove a field, hover over it, and click the **Remove field as a column** button (![Remove a field as a column button](https://www.elastic.co/docs/solutions/images/security-remove-field-button.png "title")).
![Shows the sidebar that allows you to configure the columns that display in Timeline](https://www.elastic.co/docs/solutions/images/security-timeline-sidebar.png)


## Use the Timeline query builder

Expand the query builder by clicking the query builder button (![Query builder button](https://www.elastic.co/docs/solutions/images/security-query-builder-button.png "title")) to the right of the KQL query bar. Drop in fields to build a query that filters Timeline results. The fields' relative placement specifies their logical relationships: horizontally adjacent filters use `AND`, while vertically adjacent filters use `OR`.
<tip>
  Collapse the query builder and provide more space for Timeline results by clicking the query builder button (![Query builder button](https://www.elastic.co/docs/solutions/images/security-query-builder-button.png "title")).
</tip>


## Edit existing filters

Click a filter to access additional operations such as **Add filter**, **Clear all**, **Load saved query**, and more:
![timeline ui filter options](https://www.elastic.co/docs/solutions/images/security-timeline-ui-filter-options.png)

Here are examples of various types of filters:
<definitions>
  <definition term="Field with value">
    Filters for events with the specified field value:
    ![timeline filter value](https://www.elastic.co/docs/solutions/images/security-timeline-filter-value.png)
  </definition>
  <definition term="Field exists">
    Filters for events containing the specified field:
    ![timeline field exists](https://www.elastic.co/docs/solutions/images/security-timeline-field-exists.png)
  </definition>
  <definition term="Exclude results">
    Filters for events that do not contain the specified field value (`field with value` filter) or the specified field (`field exists` filter):
    ![timeline filter exclude](https://www.elastic.co/docs/solutions/images/security-timeline-filter-exclude.png)
  </definition>
  <definition term="Temporarily disable">
    The filter is not used in the query until it is enabled again:
    ![timeline disable filter](https://www.elastic.co/docs/solutions/images/security-timeline-disable-filter.png)
  </definition>
  <definition term="Filter for field present">
    Converts a `field with value` filter to a `field exists` filter.
  </definition>
</definitions>

<note>
  When you convert a [Timeline template](https://www.elastic.co/docs/solutions/security/investigate/timeline-templates) to a Timeline, some fields may be disabled. For more information, refer to [Timeline template legend](/docs/solutions/security/investigate/timeline-templates#template-legend-ui).
</note>


## Attach Timeline to a case

To attach a Timeline to a new or existing case, open it, click **Attach to case** in the upper right corner, then select either **Attach to new case** or **Attach to existing case**.
To learn more about cases, refer to [Cases](https://www.elastic.co/docs/solutions/security/investigate/cases).

## Manage existing Timelines

You can view, duplicate, export, delete, and create templates from existing Timelines:
1. Find **Timelines** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click the **All actions** menu in the desired row, then select an action:
   - **Create template from timeline** (refer to [Timeline templates](https://www.elastic.co/docs/solutions/security/investigate/timeline-templates))
- **Duplicate timeline**
- **Export selected** (refer to [Export and import Timelines](#import-export-timelines))
- **Delete selected**
- **Create query rule from timeline** (only available if the Timeline contains a KQL query)
- **Create EQL rule from timeline** (only available if the Timeline contains an EQL query)

<tip>
  To perform an action on multiple Timelines, first select the Timelines, then select an action from the **Bulk actions** menu.
</tip>


## Export and import Timelines

You can export and import Timelines, which enables you to share Timelines from one space or Elastic Security instance to another. Exported Timelines are saved as `.ndjson` files.
To export Timelines:
- Find **Timelines** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
- Either click the **All actions** menu in the relevant row and select **Export selected**, or select multiple Timelines and then click **Bulk actions** → **Export selected**.

To import Timelines:
- Click **Import**, then select or drag and drop the relevant `.ndjson` file.
  <note>
  Multiple Timeline objects are delimited with newlines.
  </note>


## Filter Timeline results with EQL

Use the **Correlation** tab to investigate Timeline results with [EQL queries](https://www.elastic.co/docs/explore-analyze/query-filter/languages/eql).
When forming EQL queries, you can write a basic query to return a list of events and alerts. Or, you can create sequences of EQL queries to view matched, ordered events across multiple event categories. Sequence queries are useful for identifying and predicting related events. They can also provide a more complete picture of potential adversary behavior in your environment, which you can use to create or update rules and detection alerts.
The following image shows what matched ordered events look like in the Timeline table. Events that belong to the same sequence are matched together in groups and shaded red or blue. Matched events are also ordered from oldest to newest in each sequence.
![a Timeline's correlation tab](https://www.elastic.co/docs/solutions/images/security-correlation-tab-eql-query.png)

From the **Correlation** tab, you can also do the following:
- Specify the date and time range that you want to investigate.
- Reorder the columns and choose which fields to display.
- Choose a data view and whether to show detection alerts only.


## Use ES|QL to investigate events

<note>
  ES|QL is enabled by default in Kibana. It can be disabled using the `enableESQL` setting from the [Advanced Settings](https://www.elastic.co/docs/reference/kibana/advanced-settings). This will hide the ES|QL user interface from various applications. However, users will be able to access existing ES|QL artifacts like saved searches and visualizations.
</note>

The [Elasticsearch Query Language (ES|QL)](https://www.elastic.co/docs/reference/query-languages/esql) provides a powerful way to filter, transform, and analyze event data stored in Elasticsearch. ES|QL queries use "pipes" to manipulate and transform data in a step-by-step fashion. This approach allows you to compose a series of operations, where the output of one operation becomes the input for the next, enabling complex data transformations and analysis.
You can use ES|QL in Timeline by opening the **ES|QL** tab. From there, you can:
- Write an ES|QL query to explore your events. For example, start with the following query, then iterate on it to tailor your results:
  ```esql
  FROM .alerts-security.alerts-default,apm-*-transaction*,auditbeat-*,endgame-*,filebeat-*,logs-*,packetbeat-*,traces-apm*,winlogbeat-*,-*elastic-cloud-logs-*
  | LIMIT 10
  | KEEP @timestamp, message, event.category, event.action, host.name, source.ip, destination.ip, user.name
  ```
  This query does the following:
  - It starts by querying documents within the Security alert index (`.alerts-security.alerts-default`) and indices specified in the [Security data view](/docs/solutions/security/get-started/configure-advanced-settings#update-sec-indices).
- Then, the query limits the output to the top 10 results.
- Finally, it keeps the default Timeline fields (`@timestamp`, `message`, `event.category`, `event.action`, `host.name`, `source.ip`, `destination.ip`, and `user.name`) in the output.
  <tip>
  When querying indices that tend to be large (for example, `logs-*`), performance can be impacted by the number of fields returned in the output. To optimize performance, we recommend using the [`KEEP`](https://www.elastic.co/docs/reference/query-languages/esql/commands/keep) command to specify fields that you want returned. For example, add the clause `KEEP @timestamp, user.name` to the end of your query to specify that you only want the `@timestamp` and `user.name` fields returned.
  </tip>

<note>
  - An error message displays when the query bar is empty.
  - When specifying data sources for an ES|QL query, autocomplete doesn’t suggest hidden indices, such as `.alerts-*`. You must manually enter the index name or pattern.
</note>

- Click the help icon (![ES|QL reference button](https://www.elastic.co/docs/solutions/images/security-esql-help-ref-button.png "title")) on the far right side of the query editor to open the in-product reference documentation for all ES|QL commands and functions.
- Visualize query results using [Discover](https://www.elastic.co/docs/explore-analyze/discover) functionality.

![Example of the ES|QL tab in Timeline](https://www.elastic.co/docs/solutions/images/security-esql-tab.png)


### Additional ES|QL resources

To get started using ES|QL, read the tutorial for [using ES|QL in Kibana](https://www.elastic.co/docs/explore-analyze/query-filter/languages/esql-kibana). Much of the functionality available in Kibana is also available in Timeline.
To find examples of using ES|QL for threat hunting, check out [our blog](https://www.elastic.co/blog/introduction-to-esql-new-query-language-flexible-iterative-analytics).