﻿---
title: Timeline templates
description: You can attach Timeline templates to detection rules. When attached, the rule’s alerts use the template when they are investigated in Timeline. This enables...
url: https://www.elastic.co/docs/solutions/security/investigate/timeline-templates
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Timeline templates
You can attach Timeline templates to detection rules. When attached, the rule’s alerts use the template when they are investigated in Timeline. This enables immediately viewing the alert’s most interesting fields when you start an investigation.
Templates can include two types of filters:
- **Regular filter**: Like other Kibana KQL filters, defines both the source event field and its value. For example: `host.name : "win-server"`.
- **Template filter**: Only defines the event field and uses a placeholder for the field’s value. When you investigate an alert in Timeline, the field’s value is taken from the alert.

For example, if you define the `host.name: "{host.name}"` template filter, when alerts generated by the rule are investigated in Timeline, the alert’s `host.name` value is used in the filter. If the alert’s `host.name` value is `Linux_stafordshire-061`, the Timeline filter is: `host.name: "Linux_stafordshire-061"`.
<note>
  For information on how to add Timeline templates to rules, refer to [Create a detection rule](https://www.elastic.co/docs/solutions/security/detect-and-alert/create-detection-rule).
</note>

When you load Elastic Security prebuilt rules, Elastic Security also loads a selection of prebuilt Timeline templates, which you can attach to detection rules. **Generic** templates use broad KQL queries to retrieve event data, and **Comprehensive** templates use detailed KQL queries to retrieve additional information. The following prebuilt templates appear by default:
- **Alerts Involving a Single Host Timeline**: Investigate detection alerts involving a single host.
- **Alerts Involving a Single User Timeline**: Investigate detection alerts involving a single user.
- **Generic Endpoint Timeline**: Investigate Elastic Endpoint detection alerts.
- **Generic Network Timeline**: Investigate network-related detection alerts.
- **Generic Process Timeline**: Investigate process-related detection alerts.
- **Generic Threat Match Timeline**: Investigate threat indicator match detection alerts.
- **Comprehensive File Timeline**: Investigate file-related detection alerts.
- **Comprehensive Network Timeline**: Investigate network-related detection alerts.
- **Comprehensive Process Timeline**: Investigate process-related detection alerts.
- **Comprehensive Registry Timeline**: Investigate registry-related detection alerts.

<tip>
  You can [duplicate prebuilt templates](#man-templates-ui) and use them as a starting point for your own custom templates.
</tip>


## Timeline template legend

When you add filters to a Timeline template, the items are color coded to indicate which type of filter is added. Additionally, you change Timeline filters to template filters as you build your template.
<definitions>
  <definition term="Regular Timeline filter">
    Clicking **Convert to template field** changes the filter to a template filter:
    ![Timeline template filter value](https://www.elastic.co/docs/solutions/images/security-template-filter-value.png)
  </definition>
</definitions>

Template filter
![timeline template filter](https://www.elastic.co/docs/solutions/images/security-timeline-template-filter.png)

When you [convert a template to a Timeline](#man-templates-ui), template filters with placeholders are disabled:
![Invalid events filter](https://www.elastic.co/docs/solutions/images/security-invalid-filter.png)

To enable the filter, either specify a value or change it to a field’s existing filter (refer to [Edit existing filters](/docs/solutions/security/investigate/timeline#pivot)).

## Create a Timeline template

1. Choose one of the following:
   - Find **Timelines** in the main menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Next, select the **Templates** tab, then click **Create new Timeline template**.
- Go to the Timeline bar (which is at the bottom of most pages), click the ![Click the add new button](https://www.elastic.co/docs/solutions/images/security-add-new-timeline-button.png "title") button, then click **Create new Timeline template**.
- From an open Timeline  or Timeline template, click **New** → **New Timeline template**.
2. To add filters, click **Add field**, and then select the required option:
   - **Add field**: Add a regular Timeline filter.
- **Add template field**: Add a template filter with a value placeholder.
  ![Shows an example of a Timeline template](https://www.elastic.co/docs/solutions/images/security-create-a-timeline-template-field.png)
  <tip>
  You can also drag and send items to the template from the **Overview**, **Hosts**, **Network**, and **Alerts** pages.
  </tip>
3. Click **Save** to give the template a title and description.

**Example**
To create a template for process-related alerts on a specific host:
- Add a regular filter for the host name: `host.name: "Linux_stafordshire-061"`
- Add template filter for process names: `process.name: "{process.name}"`

![template query example](https://www.elastic.co/docs/solutions/images/security-template-query-example.png)

When alerts generated by rules associated with this template are investigated in Timeline, the host name is `Linux_stafordshire-061`, whereas the process name value is retrieved from the alert’s `process.name` field.

## Manage existing Timeline templates

You can view, duplicate, export, delete, and create templates from existing Timelines:
1. Find **Timelines** in the main menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then select the **Templates** tab.
   ![All actions Timeline UI](https://www.elastic.co/docs/solutions/images/security-all-actions-timeline-ui.png)
2. Click the **All actions** icon in the relevant row, and then select the action:
   - **Create timeline from template** (refer to [Create a Timeline template](#create-timeline-template))
- **Duplicate template**
- **Export selected** (refer to [Export and import Timeline templates](#import-export-timeline-templates))
- **Delete selected**
- **Create query rule from timeline** (only available if the Timeline contains a KQL query)
- **Create EQL rule from timeline** (only available if the Timeline contains an EQL query)

<tip>
  To perform the same action on multiple templates, select templates, then the required action from the **Bulk actions** menu.
</tip>

<note>
  You cannot delete prebuilt templates.
</note>


## Export and import Timeline templates

You can import and export Timeline templates, which enables importing templates from one space or Elastic Security instance to another. Exported templates are saved in an `ndjson` file.
1. Find **Timelines** in the main menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then select the **Templates** tab.
2. To export templates, do one of the following:
   - To export one template, click the **All actions** icon in the relevant row and then select **Export selected**.
- To export multiple templates, select all the required templates and then click **Bulk actions** → **Export selected**.
3. To import templates, click **Import**, then select or drag and drop the template `ndjson` file.
   <note>
   Each template object in the file must be represented in a single line. Multiple template objects are delimited with newlines.
   </note>

<note>
  You cannot export prebuilt templates.
</note>