﻿---
title: Run Osquery from investigation guides
description: Detection rule investigation guides suggest steps for triaging, analyzing, and responding to potential security issues. When you build a custom rule,...
url: https://www.elastic.co/docs/solutions/security/investigate/run-osquery-from-investigation-guides
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Run Osquery from investigation guides
Detection rule investigation guides suggest steps for triaging, analyzing, and responding to potential security issues. When you build a custom rule, you can also set up an investigation guide that incorporates Osquery. This allows you to run live queries from a rule’s investigation guide as you analyze alerts produced by the rule.
<admonition title="Requirements">
  - The [Osquery manager integration](https://www.elastic.co/docs/solutions/security/investigate/manage-integration) must be installed.
  - Elastic Agent's [status](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent) must be `Healthy`. Refer to [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems) if it isn’t.
  - In Elastic Stack, your role must have [Osquery feature privileges](https://www.elastic.co/docs/solutions/security/investigate/osquery).
  - In Serverless, you must have the appropriate user role to use this feature.
</admonition>

![Shows a live query in an investigation guide](https://www.elastic.co/docs/solutions/images/security-osquery-investigation-guide.png)


## Add live queries to an investigation guide

<note>
  You can only add Osquery to investigation guides for custom rules because prebuilt rules cannot be edited.
</note>

1. Go to the **Rules** page. To access it, find **Detection rules (SIEM)** in the main menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select a rule to open the its details, then click **Edit rule settings**.
3. Select the **About** tab, then expand the rule’s advanced settings.
4. Scroll down to the Investigation guide section. In the toolbar, click the **Osquery** button (![Click the Osquery button](https://www.elastic.co/docs/solutions/images/security-osquery-button.png "title")).
   1. Add a descriptive label for the query; for example, `Search for executables`.
2. Select a saved query or enter a new one.
   <tip>
   Use [placeholder fields](https://www.elastic.co/docs/solutions/security/investigate/use-placeholder-fields-in-osquery-queries) to dynamically add existing alert data to your query.
   </tip>
3. Expand the **Advanced** section to set a timeout period for the query, and view or set [mapped ECS fields](/docs/solutions/security/investigate/osquery#osquery-map-fields) included in the results from the live query (optional).
   <note>
   Overwriting the query’s default timeout period allows you to support queries that take longer to run. The default and minimum supported value for the **Timeout** field is `60`. The maximum supported value is `86400` (24 hours).
   </note>
   ![Shows results from running a query from an investigation guide](https://www.elastic.co/docs/solutions/images/security-setup-osquery-investigation-guide.png)
5. Click **Save changes** to add the query to the rule’s investigation guide.


## Run live queries from an investigation guide

1. Go to the **Rules** page. To access it, find **Detection rules (SIEM)** in the main menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select a rule to open the its details.
3. Go to **Rules** → **Detection rules (SIEM)**, then select a rule to open its details.
4. Go to the About section of the rule details page and click **Investigation guide**.
5. Click the query. The Run Osquery pane displays with the **Query** field autofilled. Do the following:
   1. Select one or more Elastic Agents or groups to query. Start typing in the search field to get suggestions for Elastic Agents by name, ID, platform, and policy.
2. Expand the **Advanced** section to set a timeout period for the query, and view or set [mapped ECS fields](/docs/solutions/security/investigate/osquery#osquery-map-fields) included in the results from the live query (optional).
   <note>
   Overwriting the query’s default timeout period allows you to support queries that take longer to run. The default and minimum supported value for the **Timeout** field is `60`. The maximum supported value is `86400` (24 hours).
   </note>
6. Click **Submit** to run the query. Query results display in the flyout.
   <note>
   Refer to [Examine Osquery results](https://www.elastic.co/docs/solutions/security/investigate/examine-osquery-results) for more information about query results.
   </note>
7. Click **Save for later** to save the query for future use (optional).
   ![Shows results from running a query from an investigation guide](https://www.elastic.co/docs/solutions/images/security-run-query-investigation-guide.png)