﻿---
title: Run Osquery from alerts
description: Run live queries on hosts associated with alerts to learn more about your infrastructure and operating systems. For example, with Osquery, you can search...
url: https://www.elastic.co/docs/solutions/security/investigate/run-osquery-from-alerts
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Run Osquery from alerts
Run live queries on hosts associated with alerts to learn more about your infrastructure and operating systems. For example, with Osquery, you can search your system for indicators of compromise that might have contributed to the alert. You can then use this data to inform your investigation and alert triage efforts.
<admonition title="Requirements">
  - The [Osquery manager integration](https://www.elastic.co/docs/solutions/security/investigate/manage-integration) must be installed.
  - Elastic Agent's [status](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent) must be `Healthy`. Refer to [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems) if it isn’t.
  - Your role must have the appropriate [feature privileges](/docs/solutions/security/investigate/osquery#required_osquery-privileges) in Elastic Stack or [user role](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) in Serverless.
</admonition>

To run Osquery from an alert:
1. Do one of the following from the Alerts table:
   - Click the **View details** button to open the Alert details flyout, then click **Take action → Run Osquery**.
- Select the **More actions** menu (**…**), then select **Run Osquery**.
2. Choose to run a single query or a query pack.
3. Select one or more Elastic Agents or groups to query. Start typing in the search field to get suggestions for Elastic Agents by name, ID, platform, and policy.
   <note>
   The host associated with the alert is automatically selected. You can specify additional hosts to query.
   </note>
4. Specify the query or pack to run:
   - **Query**: Select a saved query or enter a new one in the text box. After you enter the query, you can expand the **Advanced** section to set a timeout period for the query, and view or set [mapped ECS fields](/docs/solutions/security/investigate/osquery#osquery-map-fields) included in the results from the live query (optional).
  <note>
  Overwriting the query’s default timeout period allows you to support queries that take longer to run. The default and minimum supported value for the **Timeout** field is `60`. The maximum supported value is `86400` (24 hours).
  </note>
  <tip>
  Use [placeholder fields](https://www.elastic.co/docs/solutions/security/investigate/use-placeholder-fields-in-osquery-queries) to dynamically add existing alert data to your query.
  </tip>
- **Pack**: Select from available query packs. After you select a pack, all of the queries in the pack are displayed.
  <tip>
  Refer to [prebuilt packs](/docs/solutions/security/investigate/osquery#osquery-prebuilt-packs-queries) to learn about using and managing Elastic prebuilt packs.
  </tip>
  ![Shows how to set up a single query](https://www.elastic.co/docs/solutions/images/security-setup-query.png)
5. Click **Submit**. Query results will display within the flyout.
   <note>
   Refer to [Examine Osquery results](https://www.elastic.co/docs/solutions/security/investigate/examine-osquery-results) for more information about query results.
   </note>
6. Click **Save for later** to save the query for future use (optional).