﻿---
title: Open and manage cases in Elastic Security
description: You can create and manage cases using the UI or the cases API. Open a new case to keep track of security issues and share their details with colleagues...
url: https://www.elastic.co/docs/solutions/security/investigate/open-manage-cases
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Open and manage cases in Elastic Security
You can create and manage cases using the UI or the [cases API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-cases).
<note>
  **Requirements**To access and send cases to external systems, you need the appropriate [subscription or feature tier](https://www.elastic.co/pricing), and your role must have the required Kibana feature privileges. Refer to [Cases requirements](https://www.elastic.co/docs/solutions/security/investigate/cases-requirements) for more information.
</note>


## Open a new case

Open a new case to keep track of security issues and share their details with colleagues.
1. Find **Cases** in the navigation menu or search for `Security/Cases` by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then click **Create case**. If no cases exist, the Cases table will be empty and you’ll be prompted to create one by clicking the **Create case** button inside the table.
2. <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> If you defined [templates](/docs/solutions/security/investigate/configure-case-settings#cases-templates), you can optionally select one to use its default field values.
3. Give the case a name, assign a severity level, and provide a description. You can use [Markdown](https://www.markdownguide.org/cheat-sheet) syntax in the case description.
   <note>
   If you do not assign your case a severity level, it will be assigned **Low** by default.
   </note>
   <tip>
   You can insert a Timeline link in the case description by clicking the Timeline icon (![Timeline icon](https://www.elastic.co/docs/solutions/images/security-add-timeline-button.png "title")).
   </tip>
4. Optionally, add a category, assignees and relevant tags. You can add users only if they meet the necessary [prerequisites](https://www.elastic.co/docs/solutions/security/investigate/cases-requirements).
5. <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> If you defined [custom fields](/docs/solutions/security/investigate/configure-case-settings#cases-ui-custom-fields), they appear in the **Additional fields** section.
6. Choose if you want alert statuses to sync with the case’s status after they are added to the case. This option is turned on by default, but you can turn it off after creating the case.
7. <applies-to>Elastic Stack: Generally available since 9.2</applies-to> With the appropriate [Elastic Stack subscription](https://www.elastic.co/pricing) or [Serverless project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings), you can choose to automatically extract observables from alerts that you're adding to the case. This option is turned on by default. You can turn it off after creating the case by toggling **Auto-extract observables** on the case's **Observables** tab.
8. (Optional) Under **External Connector Fields**, you can select a connector to send cases to an external system. If you’ve created any connectors previously, they will be listed here. If there are no connectors listed, you can create one. For more information, refer to [External incident management systems](/docs/solutions/security/investigate/configure-case-settings#cases-ui-integrations)
   <note applies-to="Elastic Stack: Generally available since 9.3">
   When specifying **Additional fields** for an IBM Resilient connector, fields that are set when an incident is created or changed (for example, an incident is closed) won't display as an option.
   </note>
9. Click **Create case**.
   <note>
   If you’ve selected a connector for the case, the case is automatically pushed to the third-party system it’s connected to.
   </note>


## Add email notifications

You can configure email notifications that occur when users are assigned to cases.
For Kibana on Elastic Cloud:
1. Add the email domains to the [notifications domain allowlist](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts).
   You do not need to take any more steps to configure an email connector or update Kibana user settings, since the preconfigured Elastic-Cloud-SMTP connector is used by default.

For self-managed Kibana:
1. Create a preconfigured email connector.
   <note>
   At this time, email notifications support only [preconfigured email connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors), which are defined in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file.
   </note>
2. Set the `notifications.connectors.default.email` Kibana setting to the name of your email connector.
3. If you want the email notifications to contain links back to the case, you must configure the [server.publicBaseUrl](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-publicbaseurl) setting.

When you subsequently add assignees to cases, they receive an email.

## Manage existing cases

From the Cases page, you can search existing cases and filter them by attributes such as assignees, categories, severity, status, and tags. You can also select multiple cases and use bulk actions to delete cases or change their attributes. General case metrics, including how long it takes to close cases, are provided above the table.
<applies-to>Elastic Stack: Generally available since 9.3</applies-to> To find cases that were created during a specific time range, use the date time picker above the Cases table. The default time selection is the last 30 days. Clicking **Show all cases** displays every Elastic Security case in your space. The action also adjusts the starting time range to the date of when the first case was created.
To explore a case, click on its name. You can then:
- [Review the case summary](#cases-summary).
- Modify the case’s description, assignees, category, severity, status, and tags.
- Add and manage [comments](#cases-manage-comments) and [lens visualization](#cases-lens-visualization).
  <applies-to>Elastic Stack: Generally available since 9.2</applies-to> Copy and paste images into case comments using `Ctrl/Cmd` + `C` and `Ctrl/Cmd` + `V` shortcuts. Pasted images are preformatted in Markdown.
  <tip>
  Comments can contain Markdown. For syntax help, click the Markdown icon (![Click markdown icon](https://www.elastic.co/docs/solutions/images/security-markdown-icon.png "title")) in the bottom right of the comment.
  </tip>
- Add and manage the following items:
  - [Alerts](#cases-examine-alerts)
- [Indicators](/docs/solutions/security/investigate/indicators-of-compromise#review-indicator-in-case)
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> [Events](#cases-examine-events)
- [Files](#cases-add-files)
- [Observables](#cases-add-observables)
- [Manage connectors](/docs/solutions/security/investigate/configure-case-settings#cases-ui-integrations) and send updates to external systems (if you’ve added a connector to the case).
- [Copy the case UUID](#cases-copy-case-uuid)
- Refresh the case to retrieve the latest updates.


### Review the case summary

Click on an existing case to access its summary. The case summary, located under the case title, contains metrics that summarize alert information and response times. These metrics update when you attach additional unique alerts to the case, add connectors, or modify the case’s status:
- **Total alerts**: Total number of unique alerts attached to the case
- **Associated users**: Total number of unique users that are represented in the attached alerts
- **Associated hosts**: Total number of unique hosts that are represented in the attached alerts
- **Total connectors**: Total number of connectors that have been added to the case
- **Case created**: Date and time that the case was created
- **Open duration**: Time elapsed since the case was created
- **In progress duration**: How long the case has been in the `In progress` state
- **Duration from creation to close**: Time elapsed from when the case was created to when it was closed


### Manage case comments

To edit, delete, or quote a comment, select the appropriate option from the **More actions** menu (**…**).
![Shows you a summary of the case](https://www.elastic.co/docs/solutions/images/security-cases-manage-comments.png)


## Add context and supporting materials

Provide additional context and resources by adding the following to the case:
- [Alerts](#cases-examine-alerts)
- [Indicators](/docs/solutions/security/investigate/indicators-of-compromise#review-indicator-in-case)
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> [Events](#cases-examine-events)
- [Files](#cases-add-files)
- [Observables](#cases-add-observables)

<tip applies-to="Elastic Stack: Generally available since 9.3">
  From the **Attachments** tab, you can search for specific observable values, alert and event IDs, and file names.
</tip>


### Add alerts

Escalate alerts and track them in a single place by attaching them to cases. To examine the alerts, click the **Alerts** tab in the case. In the table, alerts are organized from oldest to newest. To view alert details, click the **View details** button.
You can find the **Alerts** tab in the following places:
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to>: Go to the case's details page.

<important>
  Each case can have a maximum of 1,000 alerts.
</important>

<note>
  Add alerts to new and existing cases from [Timeline](https://www.elastic.co/docs/solutions/security/investigate/timeline) or the [**Alerts** page](https://www.elastic.co/docs/solutions/security/detect-and-alert/add-detection-alerts-to-cases).
</note>


### Add events

<applies-to>
  - Elastic Stack: Generally available since 9.2
</applies-to>

Escalate events and track them in a single place by attaching them to cases. You can add events from an investigation that you've opened in Timeline, or from the **Events** tab on the **Hosts**, **Network**, or **Users** pages.
After adding events to a case, go to the **Events** tab to examine them. Within the tab, events are organized from newest to oldest. Click the **View details** button to find out more about the event.
You can find the **Events** tab in the following places:
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available in 9.2</applies-to>: Go to the case's details page.


### Add files

After you create a case, you can upload and manage files on the **Files** tab. To find the tab:
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available since 9.0</applies-to>: Go to the case's details page.

To download or delete the file or copy the file hash to your clipboard, open the action menu `boxes_horizontal`. The available hash functions are MD5, SHA-1, and SHA-256.
When you upload a file, a comment is added to the case activity log. To view an image, click its name in the activity or file list.
<important>
  When you export cases as [saved objects](https://www.elastic.co/docs/explore-analyze/find-and-organize/saved-objects), the attached case files are not exported.
</important>

<note>
  Uploaded files are also accessible from the **Files** management page, which you can find using the navigation menu or entering `Files` into the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
</note>


### Add observables

An observable is a piece of information about an investigation, for example, a suspicious URL or a file hash. Use observables to identify correlated events and better understand the severity and scope of a case.
View and manage observables from the **Observables** tab. You can find the tab in the following places:
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available since 9.0</applies-to>: Go to the case's details page.

<important>
  Each case can have a maximum of 50 observables.
</important>

To create an observable:
1. Click **Add observable** from the **Observables** tab.
2. Provide the necessary details:
   - **Type**: Select a type for the observable. You can choose a preset type or a [custom one](/docs/solutions/security/investigate/configure-case-settings#cases-observable-types).
- **Value**: Enter a value for the observable. The value must align with the type you select.
- **Description** (Optional): Provide additional information about the observable.
3. Click **Add observable**.

After adding an observable to a case, you can remove or edit it by using the **Actions** menu (**…**).
<tip>
  Go to the **Similar cases** tab to access other cases with the same observables.
</tip>

<applies-to>Elastic Stack: Generally available since 9.2</applies-to> With the appropriate [Elastic Stack subscription](https://www.elastic.co/pricing) or [Serverless project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings), you can use **Auto-extract observables** to instantly extract observables from alerts that you're adding to the case. After creating a new case, you have the option to turn it off by toggling **Auto-extract observables** on the case's **Observables** tab.

## Copy the case UUID

Each case has a universally unique identifier (UUID) that you can copy and share. To copy a case’s UUID to a clipboard, go to the **Cases** page and select **Actions** → **Copy Case ID** for the case you want to share. Alternatively, go to a case’s details page, then from the **More actions** menu (…), select **Copy Case ID**.
![Copy Case ID option in More actions menu](https://www.elastic.co/docs/solutions/images/security-cases-copy-case-id.png)


## Add a Lens visualization

<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

Add a Lens visualization to your case to portray event and alert data through charts and graphs.
![Shows how to add a visualization to a case](https://www.elastic.co/docs/solutions/images/security-add-vis-to-case.gif)

To add a Lens visualization to a comment within your case:
1. Click the **Visualization** button. The **Add visualization** dialog appears.
2. Select an existing visualization from your Visualize Library or create a new visualization.
   <important>
   Set an absolute time range for your visualization. This ensures your visualization doesn’t change over time after you save it to your case, and provides important context for others managing the case.
   </important>
3. Save the visualization to your Visualize Library by clicking the **Save to library** button (optional).
   1. Enter a title and description for the visualization.
2. Choose if you want to keep the **Update panel on Security** activated. This option is activated by default and automatically adds the visualization to your Visualize Library.
4. After you’ve finished creating your visualization, click **Save and return** to go back to your case.
5. Click **Preview** to show how the visualization will appear in the case comment.
6. Click **Add Comment** to add the visualization to your case.

Alternatively, while viewing a [dashboard](https://www.elastic.co/docs/solutions/security/dashboards) you can open a panel’s menu then click **More actions (…) → Add to existing case** or **More actions (…) → Add to new case**.
After a visualization has been added to a case, you can modify or interact with it by clicking the **Open Visualization** option in the case’s comment menu.
![Shows where the Open Visualization option is](https://www.elastic.co/docs/solutions/images/security-cases-open-vis.png)


## Export and import cases

Cases can be [exported](#cases-export) and [imported](#cases-import) as saved objects using the Kibana [Saved Objects](https://www.elastic.co/docs/explore-analyze/find-and-organize/saved-objects) UI.
<important>
  Before importing Lens visualizations, Timelines, or alerts into a space, ensure their data is present. Without it, they won’t work after being imported.
</important>


### Export a case

Use the **Export** option to move cases between different Elastic Security instances. When you export a case, the following data is exported to a newline-delimited JSON (`.ndjson`) file:
- Case details
- User actions
- Text string comments
- Case alerts
- Lens visualizations (exported as JSON blobs).

<note>
  The following attachments are *not* exported:
  - **Case files**: Case files are not exported. However, they are accessible from **Files** (find **Files** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects)) to download and re-add.
  - **Alerts**: Alerts attached to cases are not exported. You must re-add them after importing cases.
</note>

To export a case:
1. Find **Saved Objects** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Search for the case by choosing a saved object type or entering the case title in the search bar.
3. Select one or more cases, then click the **Export** button.
4. Click **Export**. A confirmation message that your file is downloading displays.
   <tip>
   Keep the **Include related objects** option enabled to ensure connectors are exported too.
   </tip>

![Shows the export saved objects workflow](https://www.elastic.co/docs/solutions/images/security-cases-export-button.png)


### Import a case

To import a case:
1. Find **Saved Objects** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Import**.
3. Select the NDJSON file containing the exported case and configure the import options.
4. Click **Import**.
5. Review the import log and click **Done**.
   <important>
   Be mindful of the following:
   - If the imported case had connectors attached to it, you’ll be prompted to re-authenticate the connectors. To do so, click **Go to connectors** on the **Import saved objects** flyout and complete the necessary steps. You can also access connectors from the **Connectors** page (find **Connectors** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects)).
   - If the imported case had attached alerts, verify that the alerts' source documents exist in the environment. Case features that interact with alerts (such as the Alert details flyout and rule details page) rely on the alerts' source documents to function.
   </important>


## Search cases

The **Cases** page has a search bar for quickly finding cases and case data. You can search for case titles, descriptions, and IDs using keywords and text. Note the following rules for search:
- **Keywords**: Searches for keywords (like case and alert IDs) must be exact.
- **Text**: Text searches (such as case titles and descriptions) are case-insensitive.
- **Syntax**: No special syntax is required when entering your search criteria.

<applies-to>Elastic Stack: Generally available since 9.3</applies-to> You can also search for alert and event IDs, observable values, case comments, and custom fields (text type only). For example, you can search for a specific IP address that's been specified as an observable, a colleague's comment, or the ID of an alert that's attached to the case.