﻿---
title: Notes
description: Incorporate notes into your investigative workflows to coordinate responses, conduct threat hunting, and share investigative findings. You can attach...
url: https://www.elastic.co/docs/solutions/security/investigate/notes
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Notes
Incorporate notes into your investigative workflows to coordinate responses, conduct threat hunting, and share investigative findings. You can attach notes to alerts, events, and Timelines and manage them from the **Notes** page.
<note>
  - <applies-to>Elastic Stack: Generally available since 9.1</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> You can attach up to 100 notes to alerts and events. The number of notes you can attach to Timelines is unlimited.
  - <applies-to>Elastic Stack: Generally available in 9.0</applies-to> Configure the `securitySolution:maxUnassociatedNotes` [advanced setting](/docs/solutions/security/get-started/configure-advanced-settings#max-notes-alerts-events) to specify the maximum number of notes that you can attach to alerts and events.
</note>


## Grant access to notes

You can control access to notes by setting the [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) for the **Notes** feature under **Security**.

## View and add notes to alerts and events

Open the alert or event details flyout to access the **Notes** tab, where you can view existing notes and add new ones. To quickly open the tab, click the **Add note** action (![Add note action](https://www.elastic.co/docs/solutions/images/security-create-note-icon.png "title")) in the Alerts or Events table. Then, enter a note into the text box, and click **Add note** to create it.
After notes are created, the **Add note** icon displays a notification dot. In the details flyout for alerts, the alert summary in the right panel also shows how many notes are attached to the alert.
![New note added to an alert](https://www.elastic.co/docs/solutions/images/security-new-note-alert-event.png)


## View and add notes to Timelines

<important>
  You can only add notes to saved Timelines.
</important>

Open the **Notes** Timeline tab, where you can view existing notes for the Timeline and add new ones. Alternatively, use the details flyout for alerts and events that you’re investigating from Timeline. Be aware that notes added this way are automatically attached to the alert or event and the Timeline unless you deselect the **Attach to current Timeline** option.
After notes are created, the **Notes** Timeline tab displays the total number of notes attached to the Timeline.
![New note added to a Timeline](https://www.elastic.co/docs/solutions/images/security-new-note-timeline-tab.png)


## Manage all notes

Use the **Notes** page to view and interact with all existing notes. To access the page, navigate to **Investigations** in the main navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then go to **Notes**. From the **Notes** page, you can:
- Search for specific notes
- Filter notes by the user who created them or by the object they’re attached to (notes can be attached to alerts, events, or Timelines)
- Examine the contents of a note (click the text in the **Note content** column)
- Delete one or more notes
- Examine the alert or event that a note is attached to (click the **Expand alert/event details** ![Preview alert or event action](https://www.elastic.co/docs/solutions/images/security-notes-page-document-details.png "title") icon)
- Open the Timeline that the note is attached to (click the **Open saved timeline** ![Open Timeline action](https://www.elastic.co/docs/solutions/images/security-notes-page-timeline-details.png "title") icon)

![Notes management page](https://www.elastic.co/docs/solutions/images/security-notes-management-page.png)