﻿---
title: Indicators of compromise
description: The Indicators page collects data from enabled threat intelligence feeds and provides a centralized view of indicators, also known as indicators of compromise...
url: https://www.elastic.co/docs/solutions/security/investigate/indicators-of-compromise
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Indicators of compromise
The Indicators page collects data from enabled threat intelligence feeds and provides a centralized view of indicators, also known as indicators of compromise (IoCs). This topic helps you set up the Indicators page and explains how to work with IoCs.
<admonition title="Requirements">
  - In Elastic Stack, the Indicators page is an [Enterprise subscription](https://www.elastic.co/pricing) feature.
  - In serverless, the Indicators page requires the Security Analytics Complete [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings)
  - You must have *one* of the following installed on the hosts you want to monitor:
    - **Elastic Agent** - Install a [Fleet-managed Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent) and ensure the agent’s status is `Healthy`. Refer to [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems) if it isn’t.
  - **Filebeat** - Install [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) version 8.x or later. Earlier Filebeat versions are incompatible with ECS and will prevent indicator data from displaying in the Indicators table.
</admonition>

![Shows the Indicators page](https://www.elastic.co/docs/solutions/images/security-indicators-table.png)


## Threat intelligence and indicators

Threat intelligence is a research function that analyzes current and emerging threats and recommends appropriate actions to strengthen a company’s security posture. Threat intelligence requires proactivity to be useful, such as gathering, analyzing, and investigating various threat and vulnerability data sources.
An indicator, also referred to as an IoC, is a piece of information associated with a known threat or reported vulnerability. There are many types of indicators, including URLs, files, domains, email addresses, and more. Within SOC teams, threat intelligence analysts use indicators to detect, assess, and respond to threats.

## Set up the Indicators page

Install a threat intelligence integration to add indicators to the Indicators page.
1. From the Elastic Security app, click **Add Integrations**.
2. In the search bar, search for `Threat Intelligence` to get a list of threat intelligence integrations.
3. Select a threat intelligence integration, then complete the integration’s guided installation.
   <note>
   For more information about available fields, go to the [Elastic integration documentation](https://docs.elastic.co/integrations) and search for a specific threat intelligence integration.
   </note>
4. Return to the Indicators page in Elastic Security. Refresh the page if indicator data isn’t displaying.


## Indicators page UI

After you add indicators to the Indicators page, you can [examine](#examine-indicator-details), search, filter, and take action on indicator data. Indicators also appear in the Trend view, which shows the total values in the legend.
![interact with indicators table](https://www.elastic.co/docs/solutions/images/security-interact-with-indicators-table.gif)


### Examine indicator details

Learn more about an indicator by clicking **View details**, then opening the Indicator details flyout. The flyout contains these informational tabs:
- **Overview**: A summary of the indicator, including the indicator’s name, the threat intelligence feed it came from, the indicator type, and additional relevant data.
  <note>
  Some threat intelligence feeds provide  [Traffic Light Protocol (TLP) markings](https://www.cisa.gov/tlp#:~:text=Introduction,shared%20with%20the%20appropriate%20audience). The `TLP Marking` and `Confidence` fields will be empty if the feed doesn’t provide that data.
  </note>
- **Table**: The indicator data in table format.
- **JSON**: The indicator data in JSON format.
  ![Shows the Indicator details flyout](https://www.elastic.co/docs/solutions/images/security-indicator-details-flyout.png)


## Find related security events

Investigate an indicator in [Timeline](https://www.elastic.co/docs/solutions/security/investigate/timeline) to identify and predict related events in your environment. You can add an indicator to Timeline from the Indicators table or the Indicator details flyout.
![Shows the results of an indicator being investigated in Timeline](https://www.elastic.co/docs/solutions/images/security-indicator-query-timeline.png)

When you add an indicator to Timeline, a new Timeline opens with an auto-generated KQL query. The query contains the indicator field-value pair that you selected plus the field-value pair of the automatically mapped source event. By default, the query’s time range is set to seven days before and after the indicator’s `timestamp`.

### Example indicator Timeline investigation

The following image shows a file hash indictor being investigated in Timeline. The indicator field-value pair is:
`threat.indicator.file.hash.sha256 : 116dd9071887611c19c24aedde270285a4cf97157b846e6343407cf3bcec115a`
![Shows the results of an indicator being investigated in Timeline](https://www.elastic.co/docs/solutions/images/security-indicator-in-timeline.png)

The auto-generated query contains the indicator field-value pair (mentioned previously) and the auto-mapped source event field-value pair, which is:
`file.hash.sha256 : 116dd9071887611c19c24aedde270285a4cf97157b846e6343407cf3bcec115a`
The query results show an alert with a matching `file.hash.sha256` field value, which may indicate suspicious or malicious activity in the environment.

## Attach indicators to cases

Attaching indicators to cases provides more context and available actions for your investigations. This feature allows you to easily share or escalate threat intelligence to other teams.
To add indicators to cases:
1. From the Indicators table, click the **More actions** (**…**) menu. Alternatively, open an indicator’s details, then select **Take action**.
2. Select one of the following:
   - **Add to existing case**: From the **Select case** dialog box, select the case to which you want to attach the indicator.
- **Add to new case**: Configure the case details. Refer to [Open a new case](/docs/solutions/security/investigate/open-manage-cases#cases-ui-open) to learn more about opening a new case.
   The indicator is added to the case as a new comment.

![An indicator attached to a case](https://www.elastic.co/docs/solutions/images/security-indicator-added-to-case.png)


### Review indicator details in cases

When you attach an indicator to a case, the indicator is added as a new comment with the following details:
- **Indicator name**: Click the linked name to open the Indicator details flyout, which contains the following tabs:
  - **Overview**: A summary of the threat indicator, including its name and type, which threat intelligence feed it came from, and additional relevant data.
  <note>
  Some threat intelligence feeds provide  [Traffic Light Protocol (TLP) markings](https://www.cisa.gov/tlp#:~:text=Introduction,shared%20with%20the%20appropriate%20audience). The `TLP Marking` and `Confidence` fields will be empty if the feed doesn’t provide that data.
  </note>
- **Table**: The indicator data in table format.
- **JSON**: The indicator data in JSON format.
- **Feed name**: The threat feed from which the indicator was ingested.
- **Indicator type**: The indicator type, for example, `file` or `.exe`.


### Remove indicators from cases

To remove an indicator attached to a case, click the **More actions** (**…**) menu → **Delete attachment** in the case comment.
![Removing an indicator from a case](https://www.elastic.co/docs/solutions/images/security-remove-indicator.png)


## Use data from indicators to expand the blocklist

Add indicator values to the [blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist) to prevent selected applications from running on your hosts. You can use MD5, SHA-1, or SHA-256 hash values from `file` type indicators.
You can add indicator values to the blocklist from the Indicators table or the Indicator details flyout. From the Indicators table, select the **More actions** (**…**) menu → **Add blocklist entry**.  Alternatively, open an indicator’s details, then select the **Take action** menu → **Add blocklist entry**.
<note>
  Refer to [Blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist) for more information about blocklist entries.
</note>