﻿---
title: Configure case settings for Elastic Security
description: This page explains how to change case closure options, add custom fields, templates, and connectors for external incident management systems, and create...
url: https://www.elastic.co/docs/solutions/security/investigate/configure-case-settings
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Configure case settings for Elastic Security
This page explains how to change case closure options, add custom fields, templates, and connectors for external incident management systems, and create custom observable types.
First, find **Cases** in the navigation menu or search for `Security/Cases` by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then click **Settings**. In Serverless, you can access case settings in an Elastic Security project, go to **Cases** → **Settings**.
![Shows the case settings page](https://www.elastic.co/docs/solutions/images/security-cases-settings.png)

<note>
  On Elastic Stack, view and change case settings, you must have the appropriate Kibana feature privileges. Refer to [Cases requirements](https://www.elastic.co/docs/solutions/security/investigate/cases-requirements).
</note>


## Case closures

If you close cases in your external incident management system, the cases will remain open in Elastic Security until you close them manually.
To close cases when they are sent to an external system, select the option to automatically close cases when pushing new incident to external system.

## External incident management systems

You can push Elastic Security cases to these third-party systems:
- ServiceNow ITSM
- ServiceNow SecOps
- Jira (including Jira Service Desk)
- IBM Resilient
- Swimlane
- TheHive
- Webhook - Case Management

To push cases, you need to create a connector, which stores the information required to interact with an external system. After you have created a connector, you can set Elastic Security cases to automatically close when they are sent to external systems.
<important>
  To create connectors and send cases to external systems, ensure you have the appropriate role privileges and [Elastic Stack subscription](https://www.elastic.co/pricing) or [Serverless project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings). For more information, refer to [Cases requirements](https://www.elastic.co/docs/solutions/security/investigate/cases-requirements).
</important>

To create a new connector:
1. From the **Incident management system** list, select **Add new connector**.
2. Select the system to send cases to: **ServiceNow**, **Jira**, **IBM Resilient**, **Swimlane**, **TheHive**, or **Webhook - Case Management**.
3. Enter your required settings. For connector configuration details, refer to:
   - [ServiceNow ITSM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
- [ServiceNow SecOps connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
- [Jira connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
- [IBM Resilient connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
- [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
- [TheHive connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/thehive-action-type)
- [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type)

To change the settings of an existing connector:
1. Select the required connector from the incident management system list.
2. Click **Update <connector name>**.
3. In the **Edit connector** flyout, modify the connector fields as required, then click **Save & close** to save your changes.

To change the default connector used to send cases to external systems, select the required connector from the incident management system list.

### Mapped case fields

When you export an Elastic Security case to an external system, case fields are mapped to existing fields in the external system. For example, the case title is mapped to the short description in ServiceNow and the summary in Jira incidents. Case tags are mapped to labels in Jira. Case comments are mapped to work notes in ServiceNow.
When you use a Webhook - Case Management connector, case fields can be mapped to custom or existing fields.
When you push updates to external systems, mapped fields are either overwritten or appended, depending on the field and the connector.
Retrieving data from external systems is not supported.

## Custom fields

You can add optional and required fields for customized case collaboration.
1. In the **Custom fields** section, click **Add field**.
   ![Add a custom field in case settings](https://www.elastic.co/docs/solutions/images/security-cases-add-custom-field.png)
2. You must provide a field label and type (text or toggle). You can optionally designate it as a required field and provide a default value.

When you create a custom field, it’s added to all new and existing cases. In existing cases, new custom text fields initially have null values.
You can subsequently remove or edit custom fields on the **Settings** page.

## Templates

<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

You can make the case creation process faster and more consistent by adding templates. A template defines values for one or all of the case fields (such as severity, tags, description, and title) as well as any custom fields.
To create a template:
1. In the **Templates** section, click **Add template**.
   ![Add a template in case settings](https://www.elastic.co/docs/solutions/images/security-cases-add-template.png)
2. You must provide a template name and case severity. You can optionally add template tags and a description, values for each case field, and a case connector.

When users create cases, they can optionally select a template and use its values or override them.
<note>
  If you update or delete templates, existing cases are unaffected.
</note>


## Observable types

<admonition title="Requirements">
  Ensure you have the appropriate [Elastic Stack subscription](https://www.elastic.co/pricing) or [Serverless project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

Create custom observable types for enhanced case collaboration.
1. In the **Observable types** section, click **Add observable type**.
2. Enter a descriptive label for the observable type, then click **Save**.

After creating a new observable type, you can remove or edit it from the **Settings** page.
<note>
  You can create up to 10 custom observable types.
</note>

<important>
  Deleting a custom observable type deletes all instances of it.
</important>

![Add an observable type in case settings](https://www.elastic.co/docs/solutions/images/security-cases-observable-types.png)