﻿---
title: Cases for Elastic Security
description: Collect and share information about security issues by opening a case in Elastic Security. Cases allow you to track key investigation details, collect...
url: https://www.elastic.co/docs/solutions/security/investigate/cases
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Cases for Elastic Security
Collect and share information about security issues by opening a case in Elastic Security. Cases allow you to track key investigation details, collect alerts in a central location, and more. The Elastic Security UI provides several ways to create and manage cases. Alternatively, you can use the [cases API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-cases) to perform the same tasks.
<applies-to>Elastic Stack: Generally available since 9.2</applies-to> Cases are automatically assigned human-readable numeric IDs, which you can use for easier referencing. Each time you create a new case in your [space](https://www.elastic.co/docs/deploy-manage/manage-spaces), the case ID increments by one. IDs are assigned to cases by a background task that runs every 10 minutes, which can cause a delay in ID assignment, especially in spaces with many cases. You can find the case ID after the case's name and can use it while searching the Cases table.
You can also send cases to these external systems by [configuring external connectors](/docs/solutions/security/investigate/configure-case-settings#cases-ui-integrations):
- ServiceNow ITSM
- ServiceNow SecOps
- Jira (including Jira Service Desk)
- IBM Resilient
- Swimlane
- Webhook - Case Management

![Case UI Home](https://www.elastic.co/docs/solutions/images/security-cases-home-page.png)

<tip applies-to="Elastic Cloud Serverless: Unavailable, Elastic Stack: Preview since 9.2">
  After creating cases, use case data to build dashboards and visualizations that provide insights into case trends and operational metrics. Refer to [Cases as data](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/cases-as-data) to learn more.
</tip>


## Limitations

- If you create cases in the Elastic Security app, they are not visible from Observability or Stack Management. Likewise, the cases you create in Stack Management are not visible in Elastic Security or Observability.
- You cannot attach alerts from the Observability or Stack Management to cases in Elastic Security.