﻿---
title: Cases requirements
description: To grant access to cases in a custom role, set the privileges for the Cases and Actions and Connectors features as follows: 
url: https://www.elastic.co/docs/solutions/security/investigate/cases-requirements
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Cases requirements
<note>
  - To send cases to external systems, ensure you have the appropriate [Elastic Stack subscription](https://www.elastic.co/pricing) or [Serverless project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
  - You need particular subscriptions and privileges to manage case attachments. For example in Elastic Stack, to add alerts to cases, you must have privileges for [managing alerts](https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-privileges). In Serverless, you need the Security Analytics Complete [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
  - If you have an on-premises deployment and want email notifications and external incident management systems to contain links back to Kibana, you must configure the [server.publicBaseUrl](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-publicbaseurl) setting.
</note>

To grant access to cases in a custom role, set the privileges for the **Cases** and **Actions and Connectors** features as follows:

| Action                                        | Kibana Privileges                                                                                                                                                                                                                                                                                                                                                                                                                 |
|-----------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Give full access to manage cases and settings | - **All** for the **Cases** feature under **Security** - **All** for the **Actions and Connectors** feature under **Management****Note:** Roles without **All** privileges for the **Actions and Connectors** feature cannot create, add, delete, or modify case connectors.  By default, **All** for the **Cases** feature allows you to have full control over cases, including deleting them, editing case settings, and more. |
| Give assignee access to cases                 | **All** for the **Cases** feature under **Security****Note:** Before a user can be assigned to a case, they must log into Kibana at least once, which creates a user profile.                                                                                                                                                                                                                                                     |
| Give view-only access for cases               | **Read** for the **Security** feature and **All** for the **Cases** feature **Note:** You can customize the sub-feature privileges to allow access to deleting cases, deleting alerts and comments from cases, viewing or editing case settings, adding case comments and attachments, and re-opening cases.                                                                                                                      |
| Revoke all access to cases                    | **None** for the **Cases** feature under **Security**                                                                                                                                                                                                                                                                                                                                                                             |