﻿---
title: Wiz
description: This page explains how to make data from the Wiz integration appear in the following places within Elastic Security: Findings page: Data appears on the...
url: https://www.elastic.co/docs/solutions/security/integrations/wiz
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Wiz
This page explains how to make data from the Wiz integration appear in the following places within Elastic Security:
- **Findings page**: Data appears on the [Vulnerabilities](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3) tab and the [Misconfiguations](https://www.elastic.co/docs/solutions/security/cloud/findings-page) tab.
- **Alert and Entity details flyouts**: Applicable data appears in the [Insights section](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section).

In order for Wiz data to appear in these workflows:
- Follow the steps to [set up the Wiz integration](https://docs.elastic.co/en/integrations/wiz).
- Make sure the integration version is at least 2.0.1.
- Ensure you have `read` privileges for the following indices: `security_solution-*.misconfiguration_latest`, `security_solution-*.vulnerability_latest`.
- While configuring the Wiz integration, turn on **Cloud Configuration Finding logs** and **Vulnerability logs**. We recommend you also set the **Initial Interval** values for both settings to `2160h` (equivalent to 90 days) to ingest existing logs.

![Wiz integration settings showing the findings toggle](https://www.elastic.co/docs/solutions/images/security-wiz-config-finding-logs.png)

![Wiz integration settings showing the vulnerabilities toggle](https://www.elastic.co/docs/solutions/images/security-wiz-config-vuln-logs.png)

Your Wiz data should now appear throughout Elastic Security.
![Wiz data on the Findings page](https://www.elastic.co/docs/solutions/images/security-wiz-findings.png)