﻿---
title: Rapid7
description: This page explains how to make data from the Rapid7 InsightVM integration (Rapid7) appear in the following places within Elastic Security: Findings page:...
url: https://www.elastic.co/docs/solutions/security/integrations/rapid7
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Rapid7
This page explains how to make data from the Rapid7 InsightVM integration (Rapid7) appear in the following places within Elastic Security:
- **Findings page**: Data appears on the [Vulnerabilities](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3) tab.
- **Alert and Entity details flyouts**: Data appears in the Insights section of the [Alert](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section) and [Entity](/docs/solutions/security/advanced-entity-analytics/view-entity-details#insights) details flyouts.

In order for Rapid7 data to appear in these workflows:
- Ensure you have read privileges for the following index: `security_solution-*.vulnerability_latest`.
- Follow the steps to [set up the Rapid7 integration](https://www.elastic.co/docs/reference/integrations/rapid7_insightvm).
- (Elastic Stack users) Ensure you're on at least v9.1.
- Make sure the Rapid7 version is at least 2.0.0.

<note>
  You can ingest data from the Rapid7 integration for other purposes without following these steps.
</note>