﻿---
title: Prisma Cloud
description: This page explains how to make data from the Prisma Cloud integration appear in the following places within Elastic Security: Findings page: Data appears...
url: https://www.elastic.co/docs/solutions/security/integrations/prisma-cloud
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Prisma Cloud
This page explains how to make data from the Prisma Cloud integration appear in the following places within Elastic Security:
- **Findings page**: Data appears on the [Vulnerabilities](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3) tab and the [Misconfiguations](https://www.elastic.co/docs/solutions/security/cloud/findings-page) tab.
- **Alert and Entity details flyouts**: Applicable data appears in the [Insights section](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section).

In order for Prisma Cloud data to appear in these workflows:
- Follow the steps to [set up the Prisma Cloud integration](https://docs.elastic.co/en/integrations/prisma_cloud).
- Make sure the integration version is at least 4.0.0.
- Ensure you have `read` privileges for the following indices: `security_solution-*.misconfiguration_latest`, `security_solution-*.vulnerability_latest`.