﻿---
title: Microsoft Defender XDR
description: This page explains how to make data from the Microsoft Defender XDR integration appear in the following places within Elastic Security: Findings page:...
url: https://www.elastic.co/docs/solutions/security/integrations/microsoft-defender-xdr
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Microsoft Defender XDR
This page explains how to make data from the Microsoft Defender XDR integration appear in the following places within Elastic Security:
- **Findings page**: Data appears on the [Vulnerabilities](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3) tab.
- **Alert and Entity details flyouts**: Data appears in the Insights section of the [Alert](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section) and [Entity](/docs/solutions/security/advanced-entity-analytics/view-entity-details#insights) details flyouts.

In order for Microsoft Defender XDR data to appear in these workflows:
- Follow the steps to [set up the Microsoft Defender XDR integration](https://www.elastic.co/docs/reference/integrations/m365_defender).
- Make sure the integration version is at least 4.0.0.
- Ensure you have `read` privileges for the following index: `security_solution-*.vulnerability_latest`.