﻿---
title: Microsoft Defender for Cloud
description: This page explains how to make data from the Microsoft Defender for Cloud integration appear in the following places within Elastic Security: Findings...
url: https://www.elastic.co/docs/solutions/security/integrations/microsoft-defender-for-cloud
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Microsoft Defender for Cloud
This page explains how to make data from the Microsoft Defender for Cloud integration appear in the following places within Elastic Security:
- **Findings page**: Data appears on the [Vulnerabilities](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3) tab and the [Misconfiguations](https://www.elastic.co/docs/solutions/security/cloud/findings-page) tab.
- **Alert and Entity details flyouts**: Data appears in the Insights section of the [Alert](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section) and [Entity](/docs/solutions/security/advanced-entity-analytics/view-entity-details#insights) details flyouts.

In order for Microsoft Defender for Cloud data to appear in these workflows:
- Follow the steps to [set up the Microsoft Defender for Cloud integration](https://www.elastic.co/docs/reference/integrations/microsoft_defender_cloud).
- Make sure the integration version is at least 3.0.0.
- Ensure you have `read` privileges for the following indices: `security_solution-*.misconfiguration_latest`, `security_solution-*.vulnerability_latest`.