﻿---
title: Ingest third-party security data
description: This section describes how to ingest security data from third-party tools into Elasticsearch. Once ingested, this data can provide additional context...
url: https://www.elastic.co/docs/solutions/security/integrations/ingest-third-party-security-data
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Ingest third-party security data
This section describes how to ingest security data from third-party tools into Elasticsearch. Once ingested, this data can provide additional context and enrich your Elastic Security workflows.
You can ingest both third-party workload protection data and third-party security posture and vulnerability data.
<note>
  This page lists only third-party integrations that collect data that can directly appear in Elastic Security workflows. For a complete list of integrations, many of which can collect security-related data, refer to [Integrations](https://www.elastic.co/docs/reference/integrations).
</note>


## Ingest third-party workload protection data

You can ingest third-party security alerts into Elastic Security to view them on the [Alerts page](/docs/solutions/security/advanced-entity-analytics/view-analyze-risk-score-data#alerts-page) and incorporate them into your triage and threat hunting workflows.
Ingest alerts from the following integrations:
- [Sysdig Falco](https://www.elastic.co/docs/solutions/security/integrations/cncf-falco).


## Ingest third-party security posture and vulnerability data

You can ingest third-party data into Elastic Security to review and investigate it alongside data collected by Elastic Security's native integrations. Once ingested, security posture and vulnerability data appears on the [**Findings**](https://www.elastic.co/docs/solutions/security/cloud/findings-page) page and in the [entity details](/docs/solutions/security/advanced-entity-analytics/view-entity-details#entity-details-flyout) and [alert details](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section) flyouts.
<note>
  Data from third-party integrations does not appear on the [CNVM dashboard](https://www.elastic.co/docs/solutions/security/cloud/cnvm-dashboard) or the [Cloud Posture dashboard](https://www.elastic.co/docs/solutions/security/dashboards/cloud-security-posture-dashboard).
</note>

Data from the following integrations can feed into your Elastic Security workflows:
- [AWS Config](https://www.elastic.co/docs/solutions/security/integrations/aws-config)
- [AWS Inspector](https://www.elastic.co/docs/solutions/security/integrations/aws-inspector)
- [AWS Security Hub](https://www.elastic.co/docs/solutions/security/integrations/aws-security-hub)
- [Google Security Command Center](https://www.elastic.co/docs/solutions/security/integrations/google-security-command-center)
- [Microsoft Defender for Cloud](https://www.elastic.co/docs/solutions/security/integrations/microsoft-defender-for-cloud)
- [Microsoft Defender for Endpoint](https://www.elastic.co/docs/solutions/security/integrations/microsoft-defender-for-endpoint)
- [Microsoft Defender XDR](https://www.elastic.co/docs/solutions/security/integrations/microsoft-defender-xdr)
- [Palo Alto Prisma Cloud](https://www.elastic.co/docs/solutions/security/integrations/prisma-cloud)
- [Qualys VMDR](https://www.elastic.co/docs/solutions/security/integrations/qualys)
- [Rapid7 InsightVM](https://www.elastic.co/docs/solutions/security/integrations/rapid7)
- [Tenable VM](https://www.elastic.co/docs/solutions/security/integrations/tenablevm)
- [Wiz](https://www.elastic.co/docs/solutions/security/integrations/wiz)