﻿---
title: AWS Security Hub
description: This page explains how to make data from the AWS Security Hub integration appear in the following places within Elastic Security: Findings page: Data...
url: https://www.elastic.co/docs/solutions/security/integrations/aws-security-hub
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# AWS Security Hub
This page explains how to make data from the AWS Security Hub integration appear in the following places within Elastic Security:
- **Findings page**: Data appears on the [Misconfigurations](https://www.elastic.co/docs/solutions/security/cloud/findings-page) tab.
- **Alert and Entity details flyouts**: Applicable data appears in the [Insights section](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section).

In order for AWS Security Hub data to appear in these workflows:
- Follow the steps to [set up the AWS Security Hub integration](https://docs.elastic.co/en/integrations/aws/securityhub).
- Make sure the integration version is at least 2.31.1.
- Ensure you have `read` privileges for the `security_solution-*.misconfiguration_latest` index.
- While configuring the AWS Security Hub integration, turn on **Collect AWS Security Hub Findings from AWS**. We recommend you also set the **Initial Interval** value to `2160h` (equivalent to 90 days) to ingest existing logs.

![AWS Security Hub integration settings showing the findings toggle](https://www.elastic.co/docs/solutions/images/security-aws-config-finding-logs.png)

<note>
  You can ingest data from the AWS Security Hub integration for other purposes without following these steps.
</note>