﻿---
title: AWS Config
description: This page explains how to make data from the AWS Config integration appear in the following places within Elastic Security: Findings page: Data appears...
url: https://www.elastic.co/docs/solutions/security/integrations/aws-config
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# AWS Config
This page explains how to make data from the AWS Config integration appear in the following places within Elastic Security:
- **Findings page**: Data appears on the [Misconfigurations](https://www.elastic.co/docs/solutions/security/cloud/findings-page) tab.
- **Alert and Entity details flyouts**: Data appears in the Insights section of the [Alert](/docs/solutions/security/detect-and-alert/view-detection-alert-details#insights-section) and [Entity](/docs/solutions/security/advanced-entity-analytics/view-entity-details#insights) details flyouts.

In order for AWS Config data to appear in these workflows:
- Follow the steps to [set up the AWS Config integration](https://docs.elastic.co/en/integrations/aws/config).
- Make sure the integration version is at least 4.0.0.
- Ensure you have `read` privileges for the following index: `security_solution-*.misconfiguration_latest`.