﻿---
title: Spaces and Elastic Security
description: Elastic Security supports the organization of your security operations into logical instances with the spaces feature. Each space in Kibana represents...
url: https://www.elastic.co/docs/solutions/security/get-started/spaces-elastic-security
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Spaces and Elastic Security
Elastic Security supports the organization of your security operations into logical instances with the [spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces) feature. Each space in Kibana represents a separate logical instance of Elastic Security in which detection rules, rule exceptions, value lists, alerts, Timelines, cases, and Kibana advanced settings are private to the space and accessible only by users that have role privileges to access the space.
For example, if you create a `SOC_prod` space in which you load and activate all the Elastic Security prebuilt detection rules, these rules and any detection alerts they generate will be accessible only when visiting the Elastic Security app in the `SOC_prod` space. If you then create a new `SOC_dev` space, you’ll notice that no detection rules or alerts are present. Any rules subsequently loaded or created here will be private to the `SOC_dev` space, and they will run independently of those in the `SOC_prod` space.
<note>
  <applies-to>Elastic Stack: Generally available since 9.1</applies-to> You can fine-tune which Elastic Defend policies and artifacts are accessible from particular spaces. For example, you can control which of your hosts running Elastic Defend appear in a particular space by using Fleet to assign Elastic Agent policies to specific spaces. Elastic Defend artifacts associated with those policies will also appear in the designated spaces. To learn more, refer to [Spaces and Elastic Security](https://www.elastic.co/docs/solutions/security/get-started/spaces-defend-faq).
</note>

<note>
  By default, alerts created by detection rules are stored in Elasticsearch indices under the `.alerts-security.alerts-<space-name>` index pattern, and they may be accessed by any user with role privileges to access those Elasticsearch indices. In our example above, any user with Elasticsearch privileges to access `.alerts-security.alerts-SOC_prod` will be able to view `SOC_prod` alerts from within Elasticsearch and other Kibana apps such as Discover.To ensure that detection alert data remains private to the space in which it was created, ensure that the roles assigned to your Elastic Security users include Elasticsearch privileges that limit their access to alerts within their space’s alerts index.
</note>