﻿---
title: Ingest data to Elastic Security
description: To ingest data, you can use: The Elastic Agent with the Elastic Defend integration, which protects your hosts and sends logs, metrics, and endpoint security...
url: https://www.elastic.co/docs/solutions/security/get-started/ingest-data-to-elastic-security
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Ingest data to Elastic Security
To ingest data, you can use:
- The [Elastic Agent](https://www.elastic.co/docs/reference/fleet) with the **Elastic Defend** integration, which protects your hosts and sends logs, metrics, and endpoint security data to Elastic Security. See [Install Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend).
- The Elastic Agent with integrations, which are available in the [Elastic Package Registry (EPR)](/docs/reference/fleet#package-registry-intro). To install an integration that works with Elastic Security, go to the Kibana Home page or navigation menu and click **Add integrations**. On the Integrations page, click the **Security** category filter, then select an integration to view the installation instructions. For more information on integrations, refer to [Integrations](https://docs.elastic.co/en/integrations).
- **Beats** shippers installed for each system you want to monitor.
- **Logstash**, which dynamically ingests, transforms, and ships your data regardless of format.
- Third-party collectors configured to ship ECS-compliant data. [Elastic Security ECS field reference](https://www.elastic.co/docs/reference/security/fields-and-object-schemas/siem-field-reference) provides a list of ECS fields used in Elastic Security.

<important>
  If you use a third-party collector—or some Logstash plugins without Elastic Agent or Beats—to ship data to Elastic Security, you must map its fields to the [Elastic Common Schema (ECS)](https://www.elastic.co/docs/reference/ecs). Additionally, you must add its index to the Elastic Security indices (update the `securitySolution:defaultIndex` [advanced setting](/docs/solutions/security/get-started/configure-advanced-settings#update-sec-indices)).Elastic Security uses the [`host.name`](https://www.elastic.co/docs/reference/ecs/ecs-host) ECS field as the primary key for identifying hosts.
</important>

The Elastic Agent with the [Elastic Defend integration](https://www.elastic.co/products/endpoint-security) ships these data sources:
- Process - Linux, macOS, Windows
- Network - Linux, macOS, Windows
- File - Linux, macOS, Windows
- DNS - Windows
- Registry - Windows
- DLL and Driver Load - Windows
- Security - Windows


## Install Beats shippers

To add hosts and populate Elastic Security with network security events, you need to install and configure Beats on the hosts from which you want to ingest security events:
- [Filebeat](https://www.elastic.co/products/beats/filebeat) for forwarding and centralizing logs and files
- [Auditbeat](https://www.elastic.co/products/beats/auditbeat) for collecting security events
- [Winlogbeat](https://www.elastic.co/products/beats/winlogbeat) for centralizing Windows event logs
- [Packetbeat](https://www.elastic.co/products/beats/packetbeat) for analyzing network activity

You can install Beats using the UI guide or directly from the command line.

### Install Beats using the UI guide

When you add integrations that use Beats, you’re guided through the Beats installation process. To begin, go to the **Integrations** page (select **Add integrations** in the toolbar on most pages), and then follow the links for the types of data you want to collect.
<tip>
  On the Integrations page, you can select the **Beats only** filter to only view integrations using Beats.
</tip>

![Shows button to add integrations](https://www.elastic.co/docs/solutions/images/security-add-integrations.png)


### Download and install Beats from the command line

To install Beats, see these installation guides:
- [Filebeat quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)
- [Auditbeat quick start](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration)
- [Winlogbeat quick start](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration)
- [Packetbeat quick start](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-installation-configuration)


### Enable modules and configuration options

No matter how you installed Beats, you need to enable modules in Auditbeat and Filebeat to populate Elastic Security with data.
<tip>
  For a full list of security-related beat modules, [click here](https://www.elastic.co/integrations?solution=security).
</tip>

To populate **Hosts** data, enable these modules:
- [Auditbeat system module  - Linux, macOS, Windows](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-system):
  - packages
- processes
- logins
- sockets
- users and groups
- [Auditbeat auditd module - Linux kernel audit events](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-auditd)
- [Auditbeat file integrity module - Linux, macOS, Windows](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-file_integrity)
- [Filebeat system module - Linux system logs](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-system)
- [Filebeat Santa module  - macOS security events](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-santa)
- [Winlogbeat - Windows event logs](https://www.elastic.co/docs/reference/beats/winlogbeat)

To populate **Network** data, enable Packetbeat protocols and Filebeat modules:
- [Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat)
  - [DNS](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-dns-options)
- [TLS](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-tls)
- [Other supported protocols](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-protocols)
- [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat)
  - [Zeek NMS module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-zeek)
- [Suricata IDS module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-suricata)
- [Iptables/Ubiquiti module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-iptables)
- [CoreDNS module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-coredns)
- [Envoy proxy module (Kubernetes)](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-envoyproxy)
- [Palo Alto Networks firewall module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-panw)
- [Cisco ASA firewall module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-cisco)
- [AWS module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-aws)
- [CEF module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-cef)
- [Google Cloud module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-gcp)
- [NetFlow module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-netflow)