﻿---
title: Quickstart: Protect your hosts with endpoint security
description: A quick start guide to securing your hosts with endpoint security.
url: https://www.elastic.co/docs/solutions/security/get-started/get-started-endpoint-security
products:
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Quickstart: Protect your hosts with endpoint security
In this guide, you’ll learn how to use Elastic Security to protect your hosts from malware, ransomware, and other threats.

## Prerequisites

- You can follow this guide using any deployment. To get up and running quickly, we recommend [Elastic Security Serverless](/docs/solutions/security/get-started#create-sec-serverless-project) with the **Security Analytics Complete** [feature tier](/docs/deploy-manage/deploy/elastic-cloud/project-settings#elastic-sec-project-features). For a complete list of deployment options, refer to [Deploy > Choosing your deployment type](/docs/deploy-manage/deploy#choosing-your-deployment-type).
- Ensure you have the minimum [system requirements](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-requirements) to install Elastic Defend.
- Ensure you grant the appropriate [Elastic Defend sub-feature privileges](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-feature-privileges).  We recommend granting them all, but you need at least `All` access for the **Endpoint List** and **Elastic Defend Policy Management** sub-features.


## Install Elastic Defend

<stepper>
  <step title="Install the Elastic Defend integration">
    Elastic Defend detects and protects endpoints from malicious activity and provides automated response options before damage and loss occur.
    <note>
      If you're installing Elastic Defend on macOS, the following instructions apply to hosts without a Mobile Device Management (MDM) profile. If your host has an MDM profile, refer to [Deploy Elastic Defend on macOS with mobile device management](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/deploy-on-macos-with-mdm).
    </note>

    <dropdown title="Steps to install Elastic Defend">
      1. On the **Get started** home page, in the **Ingest your data** section, select **Elastic Defend**, then click **Add Elastic Defend**.
      2. On the next page that says, "Ready to add your first integration?", click **Add integration only (skip agent installation)**. The integration configuration page appears.
      3. Give the Elastic Defend integration a name and enter an optional description.
      4. Select the type of environment you want to protect — **Traditional Endpoints** or **Cloud Workloads**. For this guide, we'll select **Traditional Endpoints**.
      5. Select a configuration preset, which will differ based on your prior selection. Each preset comes with different default settings for Elastic Agent, which you can further customize later by [configuring the Elastic Defend integration policy](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend). For optimal endpoint protection, we recommend selecting **Complete EDR (Endpoint, Detection & Response)**.
      6. Enter a name for the agent policy in the **New agent policy name** field.
      7. Click **Save and continue**. Next, click **Add Elastic Agent to your hosts**.
    </dropdown>
  </step>

  <step title="Add the Elastic Agent">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host.
    <dropdown title="Steps to add Elastic Agent">
      1. In the **Add agent** flyout that appears after you install the Elastic Defend integration, you'll see the policy selected that you previously added. Leave the default enrollment token selected.
      2. Ensure that the **Enroll in Fleet** option is selected. Elastic Defend cannot be integrated with Elastic Agent in standalone mode.
      3. Select the appropriate platform or operating system for the host on which you're installing the agent, then copy the provided commands.
      4. On the host, open a command-line interface and navigate to the directory where you want to install Elastic Agent. Paste and run the commands from Fleet to download, extract, enroll, and start Elastic Agent.
      5. (Optional) Return to the **Add agent** flyout, and observe the **Confirm agent enrollment** and **Confirm incoming data** steps automatically checking the host connection. It may take a few minutes for data to arrive in Elasticsearch.
      6. (Optional) After you have enrolled the Elastic Agent on your host, you can click **View enrolled agents** to access the list of agents enrolled in Fleet. Otherwise, select **Close**.
         The host will now appear on the **Endpoints** page in the Elastic Security app (**Assets** → **Endpoints**). It may take another minute or two for endpoint data to appear in Elastic Security.

      <important>
        If you’re using macOS, some versions may require you to grant Elastic Endpoint Full Disk Access to different kernels, system extensions, or files. Refer to [Elastic Defend requirements](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-requirements) for more information.
      </important>
    </dropdown>
  </step>

  <step title="Modify policy configuration settings">
    After you install the Elastic Agent with Elastic Defend, several endpoint protections—such as preventions against malware, ransomware, memory threats, and other malicious behavior—are automatically turned on for protected hosts. If any of these behaviors are detected, Elastic Defend generates an alert, and by default, prevents the malicious activity from completing. However, you can tailor the policy configuration to meet your organization’s security needs.
    <tip>
      You may want to consider analyzing which and how many alerts are generated over a specific time period to identify common patterns or anomalies before you make any policy changes. Check out the [SIEM quick start guide](https://www.elastic.co/docs/solutions/security/get-started/get-started-detect-with-siem) to learn more about how to monitor alerts.
    </tip>

    <dropdown title="Steps to modify an integration policy">
      1. From the left navigation menu, go to **Assets** → **Endpoints** → **Policies**.
      2. From the list, select the policy you want to configure. The integration policy configuration page appears.
      3. On the **Policy settings** tab, review and configure the protection, event collection, and antivirus settings as appropriate.
      4. Once you're finished making changes, click **Save** in the lower-right corner to update the policy.
      5. (Optional) You can click the **Trusted applications**, **Event filters**, **Host isolation exceptions**, and **Blocklist** tabs to review and manage those artifacts assigned to the policy, but we'll cover how to manage these in the next section.

      <note>
        For a comprehensive explanation of all endpoint protections and policy settings, refer to [Configure an integration policy](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend).
      </note>
    </dropdown>
  </step>
</stepper>


## Manage endpoints

Now that you've turned on endpoint protection, it's important not only to monitor your environment for alerts, but to manage your hosts to ensure they're healthy and have all appropriate security settings.
<note>
  You must have `admin` privileges to manage endpoints.
</note>

To view all endpoints running Elastic Defend, go to **Assets** → **Endpoints**. From here, you can view details such as agent and policy status, associated policy and IP address, or perform specific actions on the endpoint. For more information, refer to our documentation on [managing endpoints](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/endpoints).
![Endpoints page in Elastic Security](https://www.elastic.co/docs/solutions/images/security-gs-endpoint-endpoints-pg.png)

Here are some other features Elastic Security provides to help manage host configuration:
- [Endpoint response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions): Perform response actions on an endpoint using a terminal-like interface. For example, isolating or releasing a host, getting a list of processes, or suspending a running process.
  <tip>
  You can also automate some responses when an event meets the rule's criteria. Refer to [Automated response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/automated-response-actions) for more information.
  </tip>
- [Trusted applications](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications): Add Windows, macOS, and Linux applications that should be trusted so that Elastic Defend doesn't monitor them.
- [Blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist): Prevent specified applications from running on hosts to extend the list of processes that Elastic Defend considers malicious. This adds an extra layer of protection by ensuring that known malicious processes aren’t accidentally executed by end users.
- [Host isolation exceptions](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/host-isolation-exceptions): Add specific IP addresses that isolated hosts are still allowed to communicate with, even when blocked from the rest of your network.

<tip>
  You can apply trusted applications, blocklist entries, and host isolation exceptions to a single policy, or to all policies.
</tip>


## Next steps

After your hosts are secure and your environment has all the appropriate security settings configured, we recommend taking these next steps:
- Check out the [Hosts page](https://www.elastic.co/docs/solutions/security/explore/hosts-page) for a comprehensive overview of all hosts and host-related security events. This page is also useful to identify uncommon processes and anomalies discovered by machine learning jobs.
- Install and turn on prebuilt detection rules. You're already set to receive endpoint threat alerts from Elastic Defend, but did you know Elastic Security ships with several out-of-the-box rules you can turn on? Check out our [SIEM quick start guide](/docs/solutions/security/get-started/get-started-detect-with-siem#add-elastic-prebuilt-detection-rules) or our [documentation](/docs/solutions/security/detect-and-alert/install-manage-elastic-prebuilt-rules#load-prebuilt-rules).
- Discover all the other tools available to [manage Elastic Defend](https://www.elastic.co/docs/solutions/security/manage-elastic-defend).