﻿---
title: Enable threat intelligence integrations
description: The Threat Intelligence view provides a streamlined way to collect threat intelligence data that you can use for threat detection and matching. Threat...
url: https://www.elastic.co/docs/solutions/security/get-started/enable-threat-intelligence-integrations
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Enable threat intelligence integrations
The Threat Intelligence view provides a streamlined way to collect threat intelligence data that you can use for threat detection and matching. Threat intelligence data consists of  [threat indicators](/docs/solutions/security/investigate/indicators-of-compromise#ti-indicators) ingested from third-party threat intelligence sources.
Threat indicators describe potential threats, unusual behavior, or malicious activity on a network or in an environment. They are commonly used in indicator match rules to detect and match known threats. When an indicator match rule generates an alert, it includes information about the matched threat indicator.
<note>
  To learn more about alerts with threat intelligence, visit [View alert details](https://www.elastic.co/docs/solutions/security/detect-and-alert/view-detection-alert-details).
</note>

You can connect to threat intelligence sources using an [Elastic Agent integration](#agent-ti-integration), the [Threat Intel module](#ti-mod-integration), or a [custom integration](#custom-ti-integration).
![The Threat Intelligence view on the Overview dashboard](https://www.elastic.co/docs/solutions/images/getting-started-threat-intelligence-view.png)

There are a few scenarios when data won’t display in the Threat Intelligence view:
- If you’ve chosen a time range that doesn’t contain threat indicator event data, you are prompted to choose a different range. Use the date and time picker in the Elastic Security app to select a new range to analyze.
- If the Elastic Agent or Filebeat agent hasn’t ingested Threat Intel module data yet, the threat indicator event counts won’t load. You can wait for data to be ingested or reach out to your administrator for help resolving this.


## Add an Elastic Agent integration

1. Install a [Fleet-managed Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent) on the hosts you want to monitor.
2. In the Threat Intelligence view, click **Enable sources** to view the Integrations page. Scroll down and select **Elastic Agent only** to filter by Elastic Agent integrations.
   <tip>
   If you know the name of Elastic Agent integration you want to install, you can search for it directly. Alternatively, choose the **Threat Intelligence** category to display a list of available [threat intelligence integrations](https://docs.elastic.co/en/integrations/threat-intelligence-intro).
   </tip>
3. Select an Elastic Agent integration, then complete the installation steps.
4. Return to the Threat Intelligence view on the Overview dashboard. If indicator data isn’t displaying, refresh the page or refer to these [troubleshooting steps](https://www.elastic.co/docs/troubleshoot/security/indicators-of-compromise).


## Add a Filebeat Threat Intel module integration

1. Set up the [Filebeat agent](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) and enable the Threat Intel module.
   <note>
   For more information about enabling available threat intelligence filesets, refer to [Threat Intel module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-threatintel).
   </note>
2. Update the `securitySolution:defaultThreatIndex` [advanced setting](/docs/solutions/security/get-started/configure-advanced-settings#update-threat-intel-indices) by adding the appropriate index pattern name after the default Fleet threat intelligence index pattern (`logs-ti*`):
   - If you’re *only* using Filebeat version 8.x, add the appropriate Filebeat threat intelligence index pattern. For example, `logs-ti*`, `filebeat-8*`.
- If you’re using a previous version of Filebeat *and* a current one, differentiate between the threat intelligence indices by using unique index pattern names. For example, if you’re using Filebeat version 7.0.0 and 8.0.0, update the setting to `logs-ti*`,`filebeat-7*`,`filebeat-8*`.
3. Return to the Threat Intelligence view on the Overview dashboard. Refresh the page if indicator data isn’t displaying.


## Add a custom integration

1. Set up a way to [ingest data](https://www.elastic.co/docs/solutions/security/get-started/ingest-data-to-elastic-security) into your system.
2. Update the `securitySolution:defaultThreatIndex` [advanced setting](/docs/solutions/security/get-started/configure-advanced-settings#update-threat-intel-indices) by adding the appropriate index pattern name after the default Fleet threat intelligence index pattern (`logs-ti*`), for example, `logs-ti*`,`custom-ti-index*`.
   <note>
   Threat intelligence indices aren’t required to be ECS compatible. However, we strongly recommend compatibility if you’d like your alerts to be enriched with relevant threat indicator information. You can find a list of ECS-compliant threat intelligence fields at [Threat Fields](https://www.elastic.co/docs/reference/ecs/ecs-threat).
   </note>
3. Return to the Threat Intelligence view on the Overview dashboard (**Dashboards** → **Overview**). Refresh the page if indicator data isn’t displaying.
   <note>
   The Threat Intelligence view searches for a `threat.feed.name` field value to define the source name in the **Name** column. If a custom source doesn’t have the `threat.feed.name` field or hasn’t defined a `threat.feed.name` field value, it’s considered unnamed and labeled as **Other**. Dashboards aren’t created for unnamed sources unless the `threat.feed.dashboard_id` field is defined.
   </note>