﻿---
title: Elastic Security UI
description: The Elastic Security app is a highly interactive workspace designed for security analysts that provides a clear overview of events and alerts from your...
url: https://www.elastic.co/docs/solutions/security/get-started/elastic-security-ui
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Security UI
The Elastic Security app is a highly interactive workspace designed for security analysts that provides a clear overview of events and alerts from your environment. You can use the interactive UI to drill down into areas of interest.

## Search

Filter for alerts, events, processes, and other important security data by entering [Kibana Query Language (KQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql) queries in the search bar, which appears at the top of each page throughout the app. A date/time filter set to `Today` is enabled by default, but can be changed to any time range.
![search bar](https://www.elastic.co/docs/solutions/images/security-search-bar.png)

- To refine your search results, select **Add Filter** (![Add filter icon](https://www.elastic.co/docs/solutions/images/security-add-filter-icon.png "title")), then enter the field, operator (such as `is not` or `is between`), and value for your filter.
- To save the current KQL query and any applied filters, select **Saved query menu** (![Saved query menu icon](https://www.elastic.co/docs/solutions/images/security-saved-query-menu-icon.png "title")), enter a name for the saved query, and select **Save saved query**.


## Visualization actions

Many Elastic Security histograms, graphs, and tables display an **Inspect** button (![Inspect icon](https://www.elastic.co/docs/solutions/images/security-inspect-icon.png "title")) when you hover over them. Click to examine the Elasticsearch queries used to retrieve data throughout the app.
![Inspect icon](https://www.elastic.co/docs/solutions/images/security-inspect-icon-context.png)

Other visualizations display an options menu (![Three-dot menu icon](https://www.elastic.co/docs/solutions/images/security-three-dot-icon.png "title")), which allows you to inspect the visualization’s queries, add it to a new or existing case, or open it in Lens for customization.
![Options menu opened](https://www.elastic.co/docs/solutions/images/security-viz-options-menu-open.png)


## Inline actions for fields and values

Throughout the Elastic Security app, you can hover over many data fields and values to display inline actions, which allow you to customize your view or investigate further based on that field or value.
![Inline additional actions menu](https://www.elastic.co/docs/solutions/images/security-inline-actions-menu.png)

In some visualizations, these actions are available in the legend by clicking a value’s options icon (![Vertical three-dot icon](https://www.elastic.co/docs/solutions/images/security-three-dot-icon-vertical.png "title")).
![Actions in a visualization legend](https://www.elastic.co/docs/solutions/images/security-inline-actions-legend.png)

Inline actions include the following (some actions are unavailable in some contexts):
- **Filter In**: Add a filter that includes the selected value.
- **Filter Out**: Add a filter that excludes the selected value.
- **Add to timeline**: Add a filter to Timeline for the selected value.
- **Toggle column in table**: Add or remove the selected field as a column in the alerts or events table. (This action is only available on an alert’s or event’s details flyout.)
- **Show top _x_**: Display a pop-up window that shows the selected field’s top events or detection alerts.
- **Copy to Clipboard**: Copy the selected field-value pair to paste elsewhere.


## Elastic Security app pages

The Elastic Security app contains the following pages that enable analysts to view, analyze, and manage security data.

### Discover

Use the [Discover](https://www.elastic.co/docs/explore-analyze/discover) UI to filter your data or learn about its structure.

### Dashboards

Expand this section to access the following dashboards, which provide interactive visualizations that summarize your data:
- Overview
- Detection & Response
- <applies-to>Elastic Stack: Beta since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Kubernetes
- Cloud Security Posture
- Cloud Native Vulnerability Management
- Entity Analytics
- Data Quality.

You can also create and view custom dashboards. Refer to [Elastic Security dashboards](https://www.elastic.co/docs/solutions/security/dashboards) for more information.

### Rules

Expand this section to access the following pages:
- [Rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/manage-detection-rules): Create and manage rules to monitor suspicious events.
- [Benchmarks](https://www.elastic.co/docs/solutions/security/cloud/benchmarks): View, set up, or configure cloud security benchmarks.
- [Shared Exception Lists](/docs/solutions/security/detect-and-alert/rule-exceptions#shared-exception-list-intro): View and manage rule exceptions and shared exception lists.
- [MITRE ATT&CK® coverage](https://www.elastic.co/docs/solutions/security/detect-and-alert/mitre-attandckr-coverage): Review your coverage of MITRE ATT&CK® tactics and techniques, based on installed rules.


### Alerts

View and manage alerts to monitor activity within your network. Refer to [Detections and alerts](https://www.elastic.co/docs/solutions/security/detect-and-alert) for more information.

### Attack discovery

Use large language models (LLMs) to analyze alerts in your environment and identify threats. Refer to [Attack Discovery](https://www.elastic.co/docs/solutions/security/ai/attack-discovery) for more information.

### Assets

The Assets section allows you to manage the following features:
- [Fleet](https://www.elastic.co/docs/reference/fleet/manage-elastic-agents-in-fleet)
- [Endpoint protection](https://www.elastic.co/docs/solutions/security/manage-elastic-defend)
  - [Endpoints](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/endpoints): View and manage hosts running Elastic Defend.
- [Policies](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/policies): View and manage Elastic Defend integration policies.
- [Trusted applications](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications): View and manage trusted Windows, macOS, and Linux applications.
- [Event filters](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/event-filters): View and manage event filters, which allow you to filter endpoint events you don’t need to want stored in Elasticsearch.
- [Host isolation exceptions](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/host-isolation-exceptions): View and manage host isolation exceptions, which specify IP addresses that can communicate with your hosts even when those hosts are blocked from your network.
- [Blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist): View and manage the blocklist, which allows you to prevent specified applications from running on hosts, extending the list of processes that Elastic Defend considers malicious.
- [Response actions history](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/response-actions-history): Find the history of response actions performed on hosts.
- [Cloud security](https://www.elastic.co/docs/solutions/security/cloud)


### Cases

Open and track security issues. Refer to [Cases](https://www.elastic.co/docs/solutions/security/investigate/cases) to learn more.

### Entity analytics

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

<admonition title="Requirements" applies-to="Elastic Cloud Serverless: Removed, Elastic Stack: Removed in 9.3">
  To access this section, turn on the `securitySolution:enablePrivilegedUserMonitoring` [advanced setting](/docs/solutions/security/get-started/configure-advanced-settings#access-privileged-user-monitoring).
</admonition>

Expand this section to access the following pages:
- [Entity analytics](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/overview): Access a comprehensive overview of entity risk scores and anomalies identified by prebuilt anomaly detection jobs.
- [Privileged user monitoring](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/monitor-privileged-user-activitites): Set up your privileged users and monitor their activities to identify suspicious behavior.


### Explore

Expand this section to access the following pages:
- [Hosts](https://www.elastic.co/docs/solutions/security/explore/hosts-page): Examine key metrics for host-related security events using graphs, charts, and interactive data tables.
- [Network](https://www.elastic.co/docs/solutions/security/explore/network-page): Explore the interactive map to discover key network activity metrics and investigate network events further in Timeline.
- [Users](https://www.elastic.co/docs/solutions/security/explore/users-page): Access a comprehensive overview of user data to help you understand authentication and user behavior within your environment.


### Investigations

Expand this section to access the following pages:
- [Timelines](https://www.elastic.co/docs/solutions/security/investigate/timeline): Investigate alerts and complex threats — such as lateral movement — in your network. Timelines are interactive and allow you to share your findings with other team members.
  <tip>
  Click the **Timeline** button at the bottom of the Elastic Security app to start an investigation.
  </tip>
- [Notes](https://www.elastic.co/docs/solutions/security/investigate/notes): View and interact with all existing notes.
- [Osquery](https://www.elastic.co/docs/solutions/security/investigate/osquery): Deploy Osquery with Elastic Agent, then run and schedule queries.


### Findings

Identify misconfigurations and vulnerabilities in your cloud infrastructure. For setup instructions, refer to [Cloud Security Posture Management](https://www.elastic.co/docs/solutions/security/cloud/cloud-security-posture-management), [Kubernetes Security Posture Management](https://www.elastic.co/docs/solutions/security/cloud/kubernetes-security-posture-management), or [Cloud Native Vulnerability Management](https://www.elastic.co/docs/solutions/security/cloud/cloud-native-vulnerability-management).

### Intelligence

The Intelligence section contains the Indicators page, which collects data from enabled threat intelligence feeds and provides a centralized view of indicators of compromise (IoCs). Refer to [Indicators of compromise](https://www.elastic.co/docs/troubleshoot/security/indicators-of-compromise) to learn more.

### Machine learning

Manage machine learning jobs and settings. Refer to [Machine learning docs](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection) for more information.

### Get started

Quickly add security integrations that can ingest data and monitor your hosts.

### Developer tools

Use additional API and analysis tools to interact with your data.

### Management

Use the management or project settings pages to access and manage:
- Additional security features
- <applies-to>Elastic Cloud Serverless: Unavailable</applies-to> [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring)
- [Integrations](https://www.elastic.co/docs/reference/fleet/manage-integrations)
- Indices, data streams, and rollups
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> [Billing](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/serverless-project-billing-dimensions) and [subscription](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription) options for your Serverless project


## Accessibility features

Accessibility features, such as keyboard focus and screen reader support, are built into the Elastic Security UI. These features offer additional ways to navigate the UI and interact with the application.

### Interact with draggable elements

Use your keyboard to interact with draggable elements in the Elastic Security UI:
- Press the `Tab` key to apply keyboard focus to an element within a table. Or, use your mouse to click on an element and apply keyboard focus to it.
  ![timeline accessiblity keyboard focus](https://www.elastic.co/docs/solutions/images/security-timeline-accessiblity-keyboard-focus.gif)
- Press `Enter` on an element with keyboard focus to display its menu and press `Tab` to apply focus sequentially to menu options. The `f`, `o`, `a`, `t`, `c` hotkeys are automatically enabled during this process and offer an alternative way to interact with menu options.
  ![timeline accessiblity keyboard focus hotkeys](https://www.elastic.co/docs/solutions/images/security-timeline-accessiblity-keyboard-focus-hotkeys.gif)
- Press the spacebar once to begin dragging an element to a different location and press it a second time to drop it. Use the directional arrows to move the element around the UI.
  ![timeline ui accessiblity drag n drop](https://www.elastic.co/docs/solutions/images/security-timeline-ui-accessiblity-drag-n-drop.gif)
- If an event has an event renderer, press the `Shift` key and the down directional arrow to apply keyboard focus to the event renderer and `Tab` or `Shift` + `Tab` to navigate between fields. To return to the cells in the current row, press the up directional arrow. To move to the next row, press the down directional arrow.
  ![timeline accessiblity event renderers](https://www.elastic.co/docs/solutions/images/security-timeline-accessiblity-event-renderers.gif)


### Navigate the Elastic Security UI

Use your keyboard to navigate through rows, columns, and menu options in the Elastic Security UI:
- Use the directional arrows to move keyboard focus right, left, up, and down in a table.
  ![timeline accessiblity directional arrows](https://www.elastic.co/docs/solutions/images/security-timeline-accessiblity-directional-arrows.gif)
- Press the `Tab` key to navigate through a table cell with multiple elements, such as buttons, field names, and menus. Pressing the `Tab` key will sequentially apply keyboard focus to each element in the table cell.
  ![timeline accessiblity tab keys](https://www.elastic.co/docs/solutions/images/security-timeline-accessiblity-tab-keys.gif)
- Use `CTRL + Home` to shift keyboard focus to the first cell in a row. Likewise, use `CTRL + End` to move keyboard focus to the last cell in the row.
  ![timeline accessiblity shifting keyboard focus](https://www.elastic.co/docs/solutions/images/security-timeline-accessiblity-shifting-keyboard-focus.gif)
- Use the `Page Up` and `Page Down` keys to scroll through the page.
  ![timeline accessiblity page up n down](https://www.elastic.co/docs/solutions/images/security-timeline-accessiblity-page-up-n-down.gif)