﻿---
title: Elastic Security requirements
description: The Support Matrix page lists officially supported operating systems, platforms, and browsers on which components such as Beats, Elastic Agent, Elastic...
url: https://www.elastic.co/docs/solutions/security/get-started/elastic-security-requirements
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Security requirements
The [Support Matrix](https://www.elastic.co/support/matrix) page lists officially supported operating systems, platforms, and browsers on which components such as Beats, Elastic Agent, Elastic Defend, and Elastic Endpoint have been tested.

## Elastic Stack requirements

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

Elastic Security is an inbuilt part of Kibana. To use Elastic Security, you only need an Elastic Stack deployment (an Elasticsearch cluster and Kibana). Review the [Elastic Stack subscriptions](https://www.elastic.co/subscriptions) page to understand the required subscription plans for all features.
Elastic Cloud offers all of the features of Elasticsearch, Kibana, and Elastic Security as a hosted service available on AWS, GCP, and Azure. To get started, sign up for a [free Elastic Cloud trial](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
For information about installing and managing the Elastic Stack yourself, refer to [Self-managed cluster](https://www.elastic.co/docs/deploy-manage/deploy/self-managed).

### Node role requirements

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

To use Elastic Security, at least one node in your Elasticsearch cluster must have the [`transform` role](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/transforms-settings). Nodes are automatically given this role when they’re created, so changes are not required if default role settings remain the same. This applies to on-premise and cloud deployments.
Changes might be required if your nodes have customized roles. When updating node roles, nodes are only assigned the roles you specify, and default roles are removed. If you need to reassign the `transform` role to a node, [create a dedicated transform node](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings#transform-node).

## Space and index privileges

To use Elastic Security, your role must have at least:
- `Read` privilege for the `Security` feature in the [space](https://www.elastic.co/docs/deploy-manage/manage-spaces). This grants you `Read` access to all features in Elastic Security except cases. You need additional [minimum privileges](https://www.elastic.co/docs/solutions/security/investigate/cases-requirements) to use cases.
- `Read` and `view_index_metadata` privileges for all Elastic Security indices, such as `filebeat-*`, `packetbeat-*`, `logs-*`, and `endgame-*` indices.

<note>
  [Configure advanced settings](https://www.elastic.co/docs/solutions/security/get-started/configure-advanced-settings) describes how to modify Elastic Security indices.
</note>

For more information about index privileges, refer to [Elasticsearch security privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges).

## Feature-specific requirements

There are some additional requirements for specific features:
- [Detections requirements](https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-requirements)
- [Cases requirements](https://www.elastic.co/docs/solutions/security/investigate/cases-requirements)
- [Entity risk scoring requirements](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring-requirements)
- [Machine learning job and rule requirements](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/machine-learning-job-rule-requirements)
- [Elastic Defend requirements](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-requirements)
- [Configure network map data](https://www.elastic.co/docs/solutions/security/explore/configure-network-map-data)


## Advanced configuration and UI options

[Configure advanced settings](https://www.elastic.co/docs/solutions/security/get-started/configure-advanced-settings) describes how to modify advanced settings, such as the Elastic Security indices, default time intervals used in filters, and IP reputation links.

## Third-party collectors mapped to ECS

The [Elastic Common Schema (ECS)](https://www.elastic.co/docs/reference/ecs) defines a common set of fields to be used for storing event data in Elasticsearch. ECS helps users normalize their event data to better analyze, visualize, and correlate the data represented in their events. Elastic Security can ingest and normalize events from any ECS-compliant data source.
<important>
  Elastic Security requires [ECS-compliant data](https://www.elastic.co/docs/reference/ecs). If you use third-party data collectors to ship data to Elasticsearch, the data must be mapped to ECS. [Elastic Security ECS field reference](https://www.elastic.co/docs/reference/security/fields-and-object-schemas/siem-field-reference) lists ECS fields used in Elastic Security.
</important>


## Third-party collectors NOT mapped to ECS

Elastic Security does not support the use of third-party connectors that do not map data to ECS, including third-party and open source OTel collectors.

## Cross-cluster searches

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

For information on how to perform cross-cluster searches on Elastic Security indices, see:
- [Search across cluster](https://www.elastic.co/docs/explore-analyze/cross-cluster-search) (for self-managed Elastic Stack deployments)
- [Enable cross-cluster search](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-enable-ccs) (for hosted deployments)