﻿---
title: Data views and Elastic Security
description: Data views determine what data displays on Elastic Security pages with event or alert data. Data views are defined by the index patterns they include...
url: https://www.elastic.co/docs/solutions/security/get-started/data-views-elastic-security
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Data views and Elastic Security
Data views determine what data displays on Elastic Security pages with event or alert data. Data views are defined by the index patterns they include. Only data from Elasticsearch [indices](https://www.elastic.co/docs/manage-data/data-store/index-basics), [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams), or [index aliases](https://www.elastic.co/docs/manage-data/data-store/aliases) specified in the active data view will appear.
<important>
  Custom indices are not included in the [default data view](#default-data-view-security). Modify it or create a custom data view to include custom indices.
</important>


## Switch to another data view

The active data view appears under **Data view** in the upper-right corner of Elastic Security pages that display event or alert data, such as Overview, Alerts, Timelines, or Hosts. Click the menu to switch to another data view.
![image highlighting how to open the data view selection menu](https://www.elastic.co/docs/solutions/images/security-dataview-button-highlighted.png)


## Create or modify a data view

<note applies-to="Elastic Cloud Serverless: Generally available, Elastic Stack: Generally available since 9.2">
  Some data views are managed by Elastic and cannot be edited. However, you can [duplicate them](/docs/explore-analyze/find-and-organize/data-views#duplicate-managed-data-view) and make changes to duplicated versions without affecting managed data views.
</note>

To learn how to modify the default **Security Default Data View**, refer to [Update default Elastic Security indices](/docs/solutions/security/get-started/configure-advanced-settings#update-sec-indices).
To learn how to modify, create, or delete another data view refer to [Kibana Data views](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views).
<applies-to>Elastic Stack: Removed in 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Removed</applies-to> You can also temporarily modify the active data view from the **Data view** menu by clicking **Advanced options**, then adding or removing index patterns. This only allows you to add index patterns that match indices that currently contain data (other index patterns are unavailable). Note that any changes you make are saved in the browser and won’t persist if you open a new tab.
<note>
  You cannot update the data view for the Alerts page. This includes referencing a cross-cluster search (CCS) data view or any other data view. The Alerts page always shows data from `.alerts-security.alerts-default`.
</note>


## The default data view

The default data view is defined by the `securitySolution:defaultIndex` setting, which you can modify in [advanced settings](/docs/solutions/security/get-started/configure-advanced-settings#update-sec-indices).
<note>
  If you modify this view directly in the Edit data view UI, the changes will not persist.
</note>

The first time a user visits Elastic Security within a given Kibana [space](https://www.elastic.co/docs/deploy-manage/manage-spaces), the default data view generates in that space and becomes active.
<note applies-to="Elastic Stack: Generally available">
  In Elastic Stack, your Kibana space must have the **Data View Management** [feature visibility](https://www.elastic.co/docs/deploy-manage/manage-spaces) setting enabled for the default data view to generate and become active in your space.
</note>

If you delete the active data view when there are no other defined data views, the default data view will regenerate and become active upon refreshing any Elastic Security page in the space.