﻿---
title: Configure advanced settings for Elastic Security
description: The advanced settings control the behavior of the Elastic Security app, such as: Which indices Elastic Security uses to retrieve data, Machine learning...
url: https://www.elastic.co/docs/solutions/security/get-started/configure-advanced-settings
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Configure advanced settings for Elastic Security
The advanced settings control the behavior of the Elastic Security app, such as:
- Which indices Elastic Security uses to retrieve data
- Machine learning anomaly score display threshold
- The navigation menu style used throughout the Elastic Security app
- Whether the news feed is displayed on the [Overview dashboard](https://www.elastic.co/docs/solutions/security/dashboards/overview-dashboard)
- The default time interval used to filter Elastic Security pages
- The default Elastic Security pages refresh time
- Which IP reputation links appear on [IP detail](https://www.elastic.co/docs/solutions/security/explore/network-page) pages
- Whether cross-cluster search (CCS) privilege warnings are displayed
- Whether related integrations are displayed on the Rules page tables
- The options provided in the alert tag menu

<admonition title="Requirements">
  Your role must have the appropriate privileges to change advanced settings:
  - In Elastic Stack, you must have `All` privileges for the **Advanced Settings** [Kibana feature](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).
  - In Serverless, you need either the appropriate [predefined Security user role](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles) or a [custom role](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) with `All` privileges.
</admonition>

<warning>
  Modifying advanced settings can affect Kibana performance and cause problems that are difficult to diagnose. Setting a property value to a blank field reverts to the default behavior, which might not be compatible with other configuration settings. Deleting a custom setting removes it from Kibana permanently.
</warning>


## Access advanced settings

To access advanced settings, go to **Stack Management** → **Advanced Settings** in Elastic Stack or **Project Settings** → **Stack Management** → **Advanced Settings** in Serverless, then scroll down to **Security Solution** settings.
![solution advanced settings](https://www.elastic.co/docs/solutions/images/security-solution-advanced-settings.png)


## Update default Elastic Security indices

The `securitySolution:defaultIndex` field defines which Elasticsearch indices the Elastic Security app uses to collect data. By default, index patterns are used to match sets of Elasticsearch indices.
The `securitySolution:defaultIndex` field defines which Elasticsearch indices the Elastic Security app uses to collect data. By default, index patterns are used to match sets of Elasticsearch indices:
- `apm-*-transaction*`
- `auditbeat-*`
- `endgame-*`
- `filebeat-*`
- `logs-*`
- `packetbeat-*`
- `winlogbeat-*`

<note>
  Index patterns use wildcards to specify a set of indices. For example, the `filebeat-*` index pattern means all indices starting with `filebeat-` are available in the Elastic Security app.
</note>

All of the default index patterns match [Beats](https://www.elastic.co/docs/reference/beats) and [Elastic Agent](https://www.elastic.co/docs/reference/fleet) indices. This means all data shipped via Beats and the Elastic Agent is automatically added to the Elastic Security app.
You can add or remove any indices and index patterns as required. In Serverless, the maximum number of items that you can include in a comma-delimited list is 50. In Elastic Stack, there is no limit. For more information on Elasticsearch indices, refer to [Data in: documents and indices](https://www.elastic.co/docs/manage-data/data-store/index-basics).
<note>
  If you leave the `-*elastic-cloud-logs-*` index pattern selected, all Elastic cloud logs are excluded from all queries in the Elastic Security app by default. This is to avoid adding data from cloud monitoring to the app.
</note>

<important>
  Elastic Security requires [ECS-compliant data](https://www.elastic.co/docs/reference/ecs). If you use third-party data collectors to ship data to Elasticsearch, the data must be mapped to ECS. [Elastic Security ECS field reference](https://www.elastic.co/docs/reference/security/fields-and-object-schemas/siem-field-reference) lists ECS fields used in Elastic Security.
</important>


## Update default Elastic Security threat intelligence indices

The `securitySolution:defaultThreatIndex` advanced setting specifies threat intelligence indices that Elastic Security features query for ingested threat indicators. This setting affects features that query threat intelligence indices, such as the Threat Intelligence view on the Overview page, indicator match rules, and the alert enrichment query.
You can specify one or more threat intelligence indices; multiple indices must be separated by commas. By default, only the `logs-ti_*` index pattern is specified. Do not remove or overwrite this index pattern, as it is used by Elastic Agent integrations.
<important>
  Threat intelligence indices aren’t required to be ECS-compatible for use in indicator match rules. However, we strongly recommend compatibility if you want your alerts to be enriched with relevant threat indicator information. When searching for threat indicator data, indicator match rules use the threat indicator path specified in the **Indicator prefix override** advanced setting. Visit [Configure advanced rule settings](/docs/solutions/security/detect-and-alert/create-detection-rule#rule-ui-advanced-params) for more information.
</important>


## Telemetry settings

Kibana transmits certain information about Elastic Security when users interact with the Elastic Security app, detailed below. Kibana redacts or obfuscates personal data (IP addresses, host names, usernames, etc.) before transmitting messages to Elastic. Security-specific telemetry events include:
- **Detection rule security alerts:** Information about Elastic-authored prebuilt detection rules using the detection engine. Examples of alert data include machine learning job influencers, process names, and cloud audit events.
- **Elastic Endpoint Security alerts:** Information about malicious activity detected using Elastic Endpoint detection engines. Examples of alert data include malicious process names, digital signatures, and file names written by the malicious software. Examples of alert metadata include the time of the alert, the Elastic Endpoint version and related detection engine versions.
- **Configuration data for Elastic Endpoint:** Information about the configuration of Elastic Endpoint deployments. Examples of configuration data include the Endpoint versions, operating system versions, and performance counters for Endpoint.
- **Exception list entries for Elastic rules:** Information about exceptions added for Elastic rules. Examples include trusted applications, detection exceptions, and rule exceptions.
- **Security alert activity records:** Information about actions taken on alerts generated in the Elastic Security app, such as acknowledged or closed.

To learn more, refer to our [Privacy Statement](https://www.elastic.co/legal/privacy-statement).

## Set machine learning score threshold

When security [machine learning jobs](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/anomaly-detection) are enabled, this setting determines the threshold above which anomaly scores appear in Elastic Security:
- `securitySolution:defaultAnomalyScore`


## Modify news feed settings

You can change these settings, which affect the news feed displayed on the Elastic Security **Overview** page:
- `securitySolution:enableNewsFeed`: Enables the security news feed on the Security **Overview** page.
- `securitySolution:newsFeedUrl`: The URL from which the security news feed content is retrieved.


## Enable graph visualization

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.1
</applies-to>

Turn on the `securitySolution:enableGraphVisualization` setting to integrate the GraphViz visualization into the Alert and Event flyouts for supported event types. When enabled, it appears in the **Visualization** section of the flyout and can be viewed in full-screen mode.

## Enable asset inventory

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

Turn on the `securitySolution:enableAssetInventory` setting to enable the Asset Inventory in your environment.

## Enable cloud connector deployment

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

Turn on the `securitySolution:enableCloudConnector` setting to enable Cloud Connector deployment for Elastic's CSPM and Asset Inventory integrations.

## Exclude cold and frozen tier data from analyzer queries

Including data from cold and frozen [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) in [visual event analyzer](https://www.elastic.co/docs/solutions/security/investigate/visual-event-analyzer) queries may result in performance degradation. The `securitySolution:excludeColdAndFrozenTiersInAnalyzer` setting allows you to exclude this data from analyzer queries. This setting is turned off by default.

## Access the event analyzer and Session View from the event or alert details flyout

<applies-to>
  - Elastic Cloud Serverless: Removed
  - Elastic Stack: Removed in 9.1
</applies-to>

The `securitySolution:enableVisualizationsInFlyout` setting allows you to access the event analyzer and Session View in the **Visualize** [tab](/docs/solutions/security/detect-and-alert/view-detection-alert-details#expanded-visualizations-view) on the alert or event details flyout.

## Change the default search interval and data refresh time

These settings determine the default time interval and refresh rate Elastic Security pages use to display data when you open the app:
- `securitySolution:timeDefaults`: Default time interval
- `securitySolution:refreshIntervalDefaults`: Default refresh rate

<note>
  Refer to [Date Math](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options) for information about the syntax. The UI [time filter](https://www.elastic.co/docs/explore-analyze/query-filter/filtering) overrides the default values.
</note>


## Display reputation links on IP detail pages

On IP details pages (**Security** → **Network** → **IP address**), links to external sites for verifying the IP address’s reputation are displayed. By default, links to these sites are listed: [TALOS](https://talosintelligence.com/) and [VIRUSTOTAL](https://www.virustotal.com/).
The `securitySolution:ipReputationLinks` field determines which IP reputation sites are listed. To modify the listed sites, edit the field’s JSON array. These fields must be defined in each array element:
- `name`: The link’s UI display name.
- `url_template`: The link’s URL. It can include `{{ip}}`, which is placeholder for the IP address you are viewing on the **IP detail** page.

**Example**
Adds a link to [https://www.dnschecker.org](https://www.dnschecker.org) on **IP detail** pages:
```json
[
  { "name": "virustotal.com", "url_template": "https://www.virustotal.com/gui/search/{{ip}}" },
  { "name": "dnschecker.org", "url_template": "https://www.dnschecker.org/ip-location.php?ip={{ip}}" },
  { "name": "talosIntelligence.com", "url_template": "https://talosintelligence.com/reputation_center/lookup?search={{ip}}" }
]
```


## Configure cross-cluster search privilege warnings

Each time a detection rule runs using a remote cross-cluster search (CCS) index pattern, it will return a warning saying that the rule may not have the required `read` privileges to the remote index. Because privileges cannot be checked across remote indices, this warning displays even when the rule actually does have `read` privileges to the remote index.
If you’ve ensured that your detection rules have the required privileges across your remote indices, you can use the `securitySolution:enableCcsWarning` setting to disable this warning and reduce noise.

## Configure alert suppression window behavior

<applies-to>
  - Elastic Stack: Generally available since 9.2
</applies-to>

To control whether alert suppression continues after you close a supressed alert during an [active suppression window](/docs/solutions/security/detect-and-alert/suppress-detection-alerts#security-alert-suppression-impact-close-alerts), configure the `securitySolution:suppressionBehaviorOnAlertClosure` advanced setting. This setting lets you choose whether suppression continues or restarts when the next qualifying alert meets the suppression criteria. The default selection is **Restart suppression**.

## Show/hide related integrations in Rules page tables

By default, Elastic prebuilt rules in the **Rules** and **Rule Monitoring** tables include a badge showing how many related integrations have been installed. Turn off `securitySolution:showRelatedIntegrations` to hide this in the rules tables (related integrations will still appear on rule details pages).

## Manage alert tag options

The `securitySolution:alertTags` field determines which options display in the alert tag menu. The default alert tag options are `Duplicate`, `False Positive`, and `Further investigation required`. You can update the alert tag menu by editing these options or adding more. To learn more about using alert tags, refer to [Apply and filter alert tags](/docs/solutions/security/detect-and-alert/manage-detection-alerts#apply-alert-tags).

## Set the maximum notes limit for alerts and events

<applies-to>
  - Elastic Cloud Serverless: Removed
  - Elastic Stack: Removed in 9.1
</applies-to>

The `securitySolution:maxUnassociatedNotes` field determines the maximum number of [notes](https://www.elastic.co/docs/solutions/security/investigate/notes) that you can attach to alerts and events. The maximum limit and default value is 10000.

## Exclude cold and frozen data from rules

To ensure the rules in your Kibana space exclude query results from cold and frozen tiers when executing, specify cold and frozen [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) in the `excludedDataTiersForRuleExecution` field. Multiple data tiers must be separated by commas, for example: `data_frozen`, `data_cold`. This setting is turned off by default; turning it on can improve rule performance and reduce execution time.
This setting does not apply to machine learning rules because machine learning anomalies are not stored in cold or frozen data tiers.
<tip>
  To only exclude cold and frozen data from specific rules, add a [Query DSL filter](https://www.elastic.co/docs/solutions/security/detect-and-alert/exclude-cold-frozen-data-from-individual-rules) to the rules you want affected.
</tip>

<important>
  Even when the `excludedDataTiersForRuleExecution` advanced setting is enabled, indicator match, event correlation, and ES|QL rules may still fail if a frozen or cold shard that matches the rule’s specified index pattern is unavailable during rule executions. If failures occur, we recommend modifying the rule’s index patterns to only match indices containing hot tier data.
</important>


## Access privileged user monitoring

<applies-to>
  - Elastic Cloud Serverless: Removed
  - Elastic Stack: Removed in 9.3
  - Elastic Stack: Generally available from 9.1 to 9.2
</applies-to>

The `securitySolution:enablePrivilegedUserMonitoring` setting allows you to access the [Entity analytics overview page](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/overview) and the [privileged user monitoring](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/privileged-user-monitoring) feature. This setting is turned off by default.

## Turn off ES|QL-based risk scoring

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

By default, [entity risk scoring](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring) calculations are based on ES|QL queries. Turn off `securitySolution:enableEsqlRiskScoring` to use scripted metrics instead.