﻿---
title: Authenticate agentless integrations using cloud connectors
description: Cloud connector authentication for agentless integrations reduces the administrative burden of authentating to third-party cloud service providers by...
url: https://www.elastic.co/docs/solutions/security/get-started/cloud-connector-deployment
applies_to:
  - Serverless Security projects: Preview
  - Elastic Stack: Preview since 9.2
---

# Authenticate agentless integrations using cloud connectors
Cloud connector authentication for agentless integrations reduces the administrative burden of authentating to third-party cloud service providers by eliminating the need to keep track of credentials such as API keys or passwords. Cloud connectors provide a reusable, secure-by-default means of authentication, helping you to manage deployments with many integrations collecting data from multiple cloud security providers.

## Integrations that support cloud connector deployment

Cloud connector authentication currently supports deployments of Elastic's Cloud Security Posture Management (CSPM) and Asset Discovery integrations to AWS and Azure. For deployment instructions, refer to:
- Asset Discovery: [Asset Discovery on Azure](https://www.elastic.co/docs/solutions/security/cloud/asset-disc-azure); [Asset Discovery on AWS](https://www.elastic.co/docs/solutions/security/cloud/asset-disc-aws)
- CSPM: [CSPM on Azure](https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cspm-for-azure); [CSPM on AWS](https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cspm-for-aws)

<important>
  <applies-to>Elastic Stack: Removed in 9.3</applies-to><applies-to>Elastic Cloud Serverless: Removed</applies-to> To use cloud connector authentication for an AWS integration, your Kibana instance must be hosted on AWS. In other words, you must have chosen AWS hosting during Kibana setup.
</important>


## Cloud connector names

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

Cloud connector names help you keep track of each connector's purpose and reuse it appropriately. For example, you could name two AWS connectors `aws-prod` and `aws-testing`.
When you create a new cloud connector you must name it. When you're deploying an integration with a cloud connector, if you select **Existing connection** a dropdown menu with the names of existing cloud connectors appears.
To rename a connector, go to the **Existing connection** dropdown menu and click the **Edit** button next to its name, then enter a new name.
Because cloud connector names were introduced with Elastic Stack version 9.3, cloud connectors created in earlier versions have default names:
- For AWS cloud connectors: `Cloud Connector RoleARN`.
- For Azure cloud connectors: `Cloud Connector ID`.