﻿---
title: Agentless integrations
description: Agentless integrations provide a means to ingest data while avoiding the orchestration, management, and maintenance needs associated with standard ingest...
url: https://www.elastic.co/docs/solutions/security/get-started/agentless-integrations
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Agentless integrations
Agentless integrations provide a means to ingest data while avoiding the orchestration, management, and maintenance needs associated with standard ingest infrastructure. Using agentless integrations makes manual agent deployment unnecessary, allowing you to focus on your data instead of the agent that collects it.
<important>
  During technical preview, there are no additional costs associated with deploying agentless integrations.
  There is a limit of 5 agentless integrations per project.
</important>


## Requirements

- Agentless integrations are supported only on Elastic Cloud Hosted, Elastic Security Serverless, and Elastic Observability Serverless deployments.
- On Elastic Cloud Hosted, agentless integrations require a working [Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server).
- To set up a new agentless integration, you need the `Actions and connectors: all` [Kibana privilege](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).
- For Serverless deployments, traffic filtering must be turned off.


## Generally available (GA) agentless integrations

Elastic fully supports agentless deployment for the Cloud Security Posture Management (CSPM) integration. Using this integration’s agentless deployment option, you can enable Elastic’s CSPM capabilities just by providing the necessary credentials. Agentless CSPM deployments support AWS, Azure, and GCP accounts.
To learn more about agentless CSPM deployments, refer to the getting started guides for CSPM on [AWS](https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cspm-for-aws), [Azure](https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cspm-for-azure), or [GCP](https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cspm-for-gcp)

## Beta agentless integrations

Agentless deployment for other integrations is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
For setup guides and to learn more about Elastic's integrations, including whether each supports agentless deployment, refer to [Elastic integrations](https://docs.elastic.co/en/integrations/).

## Filter the integrations page to find agentless integrations

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

To identify which integrations support agentless deployment:
1. In Kibana, go to **Integrations**.
2. On the left, enable the **Only agentless integrations** toggle.