﻿---
title: Elastic Security agentless integrations FAQs
description: 
url: https://www.elastic.co/docs/solutions/security/get-started/agentless-integrations-faq
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Security agentless integrations FAQs
Frequently asked questions and troubleshooting steps for Elastic Security's agentless integrations.

## When I make a new integration, when will I see the agent appear on the Integration Policies page?

After you create a new agentless integration, the new integration policy may show a button that says **Add agent** instead of the associated agent for several minutes during agent enrollment. No action is needed other than refreshing the page once enrollment is complete.

## Why isn't my agentless agent appearing in Fleet?

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

Agentless agents (which run on Elastic's infrastructure to enable agentless integrations) do not appear on the **Fleet** page by default. To view them on this page:
<applies-switch>
  <applies-item title="{ stack: ga 9.2, serverless: }" applies-to="Elastic Cloud Serverless: Generally available, Elastic Stack: Generally available since 9.2">
    Go to the **Settings** tab of the **Fleet** page. Navigate to the **Advanced Settings** section, and enable **Show agentless resources**.
  </applies-item>

  <applies-item title="stack: ga =9.1" applies-to="Elastic Stack: Generally available in 9.1">
    Add the following query to the end of the **Fleet** page's URL: `?showAgentless=true`.
  </applies-item>
</applies-switch>


## How do I troubleshoot an `Offline` agent?

For agentless integrations to successfully connect to Elastic Security, the Fleet server host value must be the default. Otherwise, the agent status on the Fleet page will be `Offline`, and logs will include the error `[elastic_agent][error] Cannot checkin in with fleet-server, retrying`.
To troubleshoot this issue:
1. Find **Fleet** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Go to the **Settings** tab.
2. Under **Fleet server hosts**, click the **Actions** button for the policy named `Default`. This opens the Edit Fleet Server flyout. The policy named `Default` should have the **Make this Fleet server the default one** setting enabled. If not, enable it, then delete your integration and create it again.

If the **Make this Fleet server the default one** setting was already enabled but problems persist, it’s possible someone changed the default Fleet server’s **URL** value. In this case, contact Elastic Support to find out what the original **URL** value was, update the settings to match this value, then delete your integration and create it again.
<note applies-to="Elastic Cloud Hosted: Generally available">
  In Elastic Cloud Hosted deployments on Elastic Stack versions prior to 9.1.6, the connection between agentless integrations and Fleet Server can break if the default Fleet Server host URL value in Fleet is modified or if a different host URL is set as the default.This issue is resolved in Elastic Stack 9.1.6. In this and later versions, agentless integration policies are assigned to a default managed Fleet Server host which cannot be modified.
</note>


## Why can't I upgrade my agentless integration to a newer version?

On versions of Elastic Stack before v9.2, agentless integrations can't be upgraded to newer versions of the integration. To get a newer version in your Elastic Stack environment, upgrade to Elastic Stack v9.2+ or delete and re-install the desired integration.

## How do I troubleshoot an `Unhealthy` agent?

On the **Fleet** page, agents associated with agentless integrations have names that begin with `agentless`. To troubleshoot an `Unhealthy` agent:
1. Go to the **Settings** tab of the **Fleet** page. Go to the **Advanced Settings** section, and turn on the **Show agentless resources** toggle.
2. In Fleet, select the unhealthy agent.
3. From the **Actions** menu, select **Request diagnostics .zip**.
4. Download and unzip the [diagnostics bundle](/docs/troubleshoot/ingest/fleet/common-problems#trb-collect-agent-diagnostics). Refer to [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems) for more information.


## How do I delete an agentless integration?

<note>
  Deleting your integration will remove all associated resources and stop data ingestion.
</note>

When you create a new agentless integration, a new agent policy appears within the **Agent policies** tab on the **Fleet** page, but you can’t use the **Delete integration** button on this page. Instead, you must delete the integration from the Integration’s **Integration policies** tab.
1. Find **Integrations** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then search for your integration.
2. Go to the integration’s **Integration policies** tab.
3. Find the integration policy for the integration you want to delete. Click **Actions**, then **Delete integration**.
4. Confirm by clicking **Delete integration** again.


## Can agentless integrations use a specific range of static IP addresses for configuring allow and deny rules for traffic?

No, agentless integrations can not use a specific range of static IP addresses for configuring ingress and egress allow and deny rules.

## Do agentless integrations work if I'm using traffic filtering?

<applies-switch>
  <applies-item title="serverless: ga" applies-to="Elastic Cloud Serverless: Generally available">
    Agentless integrations do not support traffic filtering.
  </applies-item>

  <applies-item title="stack: ga 9.1+" applies-to="Elastic Stack: Generally available since 9.1">
    Agentless integrations support traffic filtering. No additional configuration is necessary.
  </applies-item>
</applies-switch>