﻿---
title: Get started with Elastic Security
description: New to Elastic Security? Follow the instructions in this topic to get started. Then, review the rest of the Get Started section to learn how to use the...
url: https://www.elastic.co/docs/solutions/security/get-started
products:
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Get started with Elastic Security
New to Elastic Security? Follow the instructions in this topic to get started. Then, review the rest of the Get Started section to learn how to use the UI, review requirements, and discover more about our security features.
<stepper>
  <step title="Choose your deployment type">
    Elastic provides several self-managed and Elastic-managed options. For simplicity and speed, we recommend Elastic Security Serverless, which enables you to run Elastic Security in a fully managed environment so you don’t have to manage the underlying Elasticsearch cluster and Kibana instances.
    <dropdown title="Create an Elastic Security Serverless project">
      There are two options to create serverless projects:
      - If you're a new user, [sign up for a free 14-day trial](https://cloud.elastic.co/serverless-registration). For more information about Elastic Cloud trials, check out [Trial information](/docs/deploy-manage/deploy/elastic-cloud/create-an-organization#general-sign-up-trial-what-is-included-in-my-trial).
      - If you're an existing customer, [log in to Elastic Cloud](https://cloud.elastic.co/login) and do the following:
        1. Select **Create project** from the **Serverless projects** panel.
      2. Select **Next** from the **Security** panel.
      3. Name your project and select your feature tier. For more information about tiers, refer to [pricing](https://www.elastic.co/pricing/serverless-security).
      4. Select a cloud provider and region.
      5. Select **Create project**. It takes a few minutes to create your project.
      6. Once the project is ready, select **Continue** to open the **Get started** page (you might need to log in to Elastic Cloud again).   From here, you can learn more about Elastic Security features and start setting up your workspace.

      <note>
        You need the `admin` predefined role or an equivalent custom role to create projects. For more information, refer to [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
      </note>
      After you've created your project, you're ready to move on to the next step.
    </dropdown>
    Alternatively, if you prefer a self-managed deployment, you can create a [local development installation](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart) in Docker:
    ```sh
    curl -fsSL https://elastic.co/start-local | sh
    ```
    Check out the complete list of [deployment types](/docs/deploy-manage/deploy#choosing-your-deployment-type) to learn more.
  </step>

  <step title="Ingest your data">
    After you've deployed Elastic Security, the next step is to get data into the product before you can search, analyze, or use any visualization tools. The easiest way to get data into Elastic Security is through one of our hundreds of ready-made integrations. You can add an integration directly from the **Get Started** page within the **Ingest your data** section:
    1. At the top of the page, click **Set up Security**.
    2. In the Ingest your data section, click **Add data with integrations**.
    3. Choose from one of our recommended integrations, or select another tab to browse by category.

    ![Ingest data](https://www.elastic.co/docs/solutions/images/security-gs-ingest-data.png)
    Elastic also provides different [ingestion methods](https://www.elastic.co/docs/manage-data/ingest) to meet your infrastructure needs.
    <tip>
      If you have data from a source that doesn't yet have an integration, you can use [Automatic Import](https://www.elastic.co/docs/solutions/security/get-started/automatic-import) to create one using AI.
    </tip>
  </step>

  <step title="Get started with your use case">
    Not sure where to start exploring Elastic Security
    or which features may be relevant to you? Continue to the next topic to view our [quickstart guides](https://www.elastic.co/docs/solutions/security/get-started/quickstarts), each of which is tailored to a specific use case and helps you complete a core task so you can get up and running.
  </step>
</stepper>


## Related resources

Use these resources to learn more about Elastic Security or get started in a different way.
- Migrate your SIEM rules from Splunk's Search Processing Language (SPL) to Elasticsearch Query Language (ES|QL) using [Automatic Migration](https://www.elastic.co/docs/solutions/security/get-started/automatic-migration).
- Check out the numerous [Security integrations](https://www.elastic.co/integrations/data-integrations?solution=security) available to collect and process your data.
- Get started with [AI for Security](https://www.elastic.co/docs/solutions/security/ai).
- Learn how to use Elasticsearch Query Language (ES|QL) for [security use cases](https://www.elastic.co/docs/solutions/security/esql-for-security).
- View our [release notes](https://www.elastic.co/docs/release-notes/security) for the latest updates.