﻿---
title: ES|QL for security use cases
description: Use the following resources to learn about using the Elasticsearch Query Language (ES|QL) for cybersecurity use cases. Threat hunting with ES|QL: Learn...
url: https://www.elastic.co/docs/solutions/security/esql-for-security
products:
  - Elastic Security
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ES|QL for security use cases
Use the following resources to learn about using the [Elasticsearch Query Language (ES|QL)](https://www.elastic.co/docs/reference/query-languages/esql) for cybersecurity use cases.

## Tutorials

- [Threat hunting with ES|QL](https://www.elastic.co/docs/solutions/security/esql-for-security/esql-threat-hunting-tutorial): Learn how to use ES|QL to hunt for threats in your data.


## Documentation

Learn how to:
- [Generate and understand ES|QL queries](https://www.elastic.co/docs/solutions/security/ai/generate-customize-learn-about-esorql-queries) using the AI Assistant
- [Investigate events in Timeline](/docs/solutions/security/investigate/timeline#esql-in-timeline) using ES|QL
- [Create detection rules](/docs/solutions/security/detect-and-alert/create-detection-rule#create-esql-rule) using ES|QL
- [Convert Splunk SPL rules to ES|QL](https://www.elastic.co/docs/solutions/security/get-started/automatic-migration) with Automatic Migration