﻿---
title: Third-party response actions
description: You can perform response actions on hosts enrolled in other third-party endpoint protection systems, such as CrowdStrike or SentinelOne. For example,...
url: https://www.elastic.co/docs/solutions/security/endpoint-response-actions/third-party-response-actions
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Third-party response actions
You can perform response actions on hosts enrolled in other third-party endpoint protection systems, such as CrowdStrike or SentinelOne. For example, you can direct the other system to isolate a suspicious endpoint from your network, without leaving the Elastic Security UI.
<admonition title="Requirements">
  - Third-party response actions require the appropriate [subscription](https://www.elastic.co/pricing) in Elastic Stack or [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings) in Serverless.
  - Each response action type has its own user role privilege requirements. Find an action’s role requirements at [Endpoint response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions).
  - Additional [configuration](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/configure-third-party-response-actions) is required to connect Elastic Security with a third-party system.
</admonition>


## CrowdStrike response actions

These response actions are supported for CrowdStrike-enrolled hosts:
- **Isolate and release a host** using any of these methods:
  - From a detection alert
- From the response console
  Refer to the instructions on [isolating](/docs/solutions/security/endpoint-response-actions/isolate-host#isolate-a-host) and [releasing](/docs/solutions/security/endpoint-response-actions/isolate-host#release-a-host) hosts for more details.
- **Run a script on a host** with the [`runscript` response action](/docs/solutions/security/endpoint-response-actions#crowdstrike).
- **View past response action activity** in the [response actions history](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/response-actions-history) log.


## Microsoft Defender for Endpoint response actions

These response actions are supported for Microsoft Defender for Endpoint–enrolled hosts:
- **Isolate and release a host** using any of these methods:
  - From a detection alert
- From the response console
  Refer to the instructions on [isolating](/docs/solutions/security/endpoint-response-actions/isolate-host#isolate-a-host) and [releasing](/docs/solutions/security/endpoint-response-actions/isolate-host#release-a-host) hosts for more details.
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> **Run a script on a host** with the [`runscript` response action](/docs/solutions/security/endpoint-response-actions#microsoft-defender-for-endpoint).
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> **Cancel an ongoing action on a host** with the [`cancel` response action](/docs/solutions/security/endpoint-response-actions#cancel).


## SentinelOne response actions

These response actions are supported for SentinelOne-enrolled hosts:
- **Isolate and release a host** using any of these methods:
  - From a detection alert
- From the response console
  Refer to the instructions on [isolating](/docs/solutions/security/endpoint-response-actions/isolate-host#isolate-a-host) and [releasing](/docs/solutions/security/endpoint-response-actions/isolate-host#release-a-host) hosts for more details.
- **Retrieve a file from a host** with the [`get-file` response action](/docs/solutions/security/endpoint-response-actions#get-file).
  <note>
  For SentinelOne-enrolled hosts, you must use the password `Elastic@123` to open the retrieved file.
  </note>
- **Get a list of processes running on a host** with the [`processes` response action](/docs/solutions/security/endpoint-response-actions#processes). For SentinelOne-enrolled hosts, this command returns a link for downloading the process list in a file.
- **Terminate a process running on a host** with the [`kill-process` response action](/docs/solutions/security/endpoint-response-actions#kill-process).
  <note>
  For SentinelOne-enrolled hosts, you must use the parameter `--processName` to identify the process to terminate. `--pid` and `--entityId` are not supported.Example: `kill-process --processName cat --comment "Terminate suspicious process"`
  </note>
- **View past response action activity** in the [response actions history](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/response-actions-history) log.
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> **Run a script on a host** with the [`runscript` response action](/docs/solutions/security/endpoint-response-actions#sentinelone).