﻿---
title: Automated response actions
description: Add Elastic Defend's response actions to detection rules to automatically perform actions on an affected host when an event meets the rule’s criteria...
url: https://www.elastic.co/docs/solutions/security/endpoint-response-actions/automated-response-actions
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Automated response actions
Add Elastic Defend's [response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions) to detection rules to automatically perform actions on an affected host when an event meets the rule’s criteria. Use these actions to support your response to detected threats and suspicious events.
<admonition title="Requirements">
  - Automated response actions require the appropriate [subscription](https://www.elastic.co/pricing) in Elastic Stack or [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings) in Serverless.
  - Hosts must have Elastic Agent installed with the Elastic Defend integration.
  - Your user role must have the ability to create detection rules and the privilege to perform [specific response actions](/docs/solutions/security/endpoint-response-actions#response-action-commands) (for example, the **Host Isolation** privilege to isolate hosts).
</admonition>

To add automated response actions to a new or existing rule:
1. Do one of the following:
   - **New rule**: On the last step of rule creation, go to the **Response Actions** section and select **Elastic Defend**.
- **Existing rule**: Edit the rule’s settings, then go to the **Actions** tab. In the tab, select **Elastic Defend** under the **Response Actions** section.
2. Select an option in the **Response action** field:
   - **Isolate**: [Isolate the host](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/isolate-host), blocking communication with other hosts on the network.
  <important>
  Be aware that automatic host isolation can result in unintended consequences, such as disrupting legitimate user activities or blocking critical business processes.
  </important>
- **Kill process**: Terminate a process on the host.
- **Suspend process**: Temporarily suspend a process on the host.
3. For process actions, specify how to identify the process you want to terminate or suspend:
   - Turn on the toggle to use the alert’s **process.pid** value as the identifier.
- To use a different alert field value to identify the process, turn off the toggle and enter the **Custom field name**.
4. Enter a comment describing why you’re performing the action on the host (optional).
5. To finish adding the response action, click **Create & enable rule** (for a new rule) or **Save changes** (for existing rules).