﻿---
title: Visualize detection alerts
description: Visualize and group detection alerts by specific parameters in the visualization section of the Alerts page. Use the left buttons to select a view type...
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/visualize-detection-alerts
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Visualize detection alerts
Visualize and group detection alerts by specific parameters in the visualization section of the Alerts page.
![Alerts page with visualizations section](https://www.elastic.co/docs/solutions/images/security-alert-page.png)

Use the left buttons to select a view type (**Summary**, **Trend**, **Counts**, or **Treemap**), and use the right menus to select the ECS fields to use for grouping:
- **Top alerts by** or **Group by**: Primary field for grouping alerts.
- **Group by top** (if available): Secondary field for further subdividing grouped alerts.

For example, you can group first by rule name (`Group by: kibana.alert.rule.name`), then by host name (`Group by top: host.name`) to visualize which detection rules generated alerts, and which hosts triggered each of those rules. For groupings with a lot of unique values, the top 1,000 results are displayed.
<note>
  Some view types don’t have the **Group by top** option. You can also leave **Group by top** blank to group by only the primary field in **Group by**.
</note>

To reset a view to default settings, hover over it and click the options menu (![More actions](https://www.elastic.co/docs/solutions/images/security-three-dot-icon.png "title")) that appears, then select **Reset group by fields**.
<tip>
  The options menu also lets you inspect the visualization’s queries. For the trend and counts views, you can add the visualization to a new or existing case, or open it in Lens.
</tip>

Click the collapse icon (![Collapse icon](https://www.elastic.co/docs/solutions/images/security-collapse-icon-horiz-down.png "title")) to minimize the visualization section and display a summary of key information instead.
![Alerts page with visualizations section collapsed](https://www.elastic.co/docs/solutions/images/security-alert-page-viz-collapsed.png)


## Summary

On the Alerts page, the summary visualization displays by default and shows how alerts are distributed across these indicators:
- **Severity levels**: How many alerts are in each severity level.
- **Alerts by name**: How many alerts each detection rule created.
- **Top alerts by**: Percentage of alerts with a specified field value: `host.name` (default), `user.name`, `source.ip`, or `destination.ip`.

You can interact with elements within the summary—such as severity levels, rule names, and host names—to add filters with those values to the Alerts page.
![Summary visualization for alerts](https://www.elastic.co/docs/solutions/images/security-alerts-viz-summary.png)


## Trend

The trend view shows the occurrence of alerts over time. By default, it groups alerts by detection rule name (`kibana.alert.rule.name`).
<note>
  The **Group by top** menu is unavailable for the trend view.
</note>

![Trend visualization for alerts](https://www.elastic.co/docs/solutions/images/security-alerts-viz-trend.png)


## Counts

The counts view shows the count of alerts in each group. By default, it groups alerts first by detection rule name (`kibana.alert.rule.name`), then by host name (`host.name`).
![Counts visualization for alerts](https://www.elastic.co/docs/solutions/images/security-alerts-viz-counts.png)


## Treemap

The treemap view shows the distribution of alerts as nested, proportionally-sized tiles. This view can help you quickly pinpoint the most prevalent and critical alerts.
![Treemap visualization for alerts](https://www.elastic.co/docs/solutions/images/security-alerts-viz-treemap.png)

Larger tiles represent more frequent alerts, and each tile’s color is based on the alerts' risk score:
- **Green**: Low risk (`0` - `46`)
- **Yellow**: Medium risk (`47` - `72`)
- **Orange**: High risk (`73` - `98`)
- **Red**: Critical risk (`99` - `100`)

By default, the treemap groups alerts first by detection rule name (`kibana.alert.rule.name`), then by host name (`host.name`). This shows which rules generated the most alerts, and which hosts were responsible.
<note>
  Depending on the amount of alerts, some tiles and text might be very small. Hover over the treemap to display information in a tooltip.
</note>

You can click on the treemap to narrow down the alerts displayed in both the treemap and the alerts table below. Click the label above a group to display the alerts in that group, or click an individual tile to display the alerts related to that tile. This adds filters under the KQL search bar, which you can edit or remove to further customize the view.
![Animation of clicking the treemap](https://www.elastic.co/docs/solutions/images/security-treemap-click.gif)