﻿---
title: Rule exceptions
description: You can associate rule exceptions with detection and endpoint rules to prevent trusted processes and network activity from generating unnecessary alerts,...
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/rule-exceptions
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Rule exceptions
You can associate rule exceptions with detection and endpoint rules to prevent trusted processes and network activity from generating unnecessary alerts, therefore, reducing the number of false positives.
When creating exceptions, you can assign them to [individual rules](#rule-exceptions-intro) or to [multiple rules](#shared-exception-list-intro).

## Exceptions for individual rules

Exceptions, also referred to as *exception items*, contain the source event conditions that determine when alerts shouldn’t be generated.
You can create exceptions that apply exclusively to a single rule. These types of exceptions can’t be used by other rules, and you must manage them from the rule’s details page. To learn more about creating and managing single-rule exceptions, refer to [Add and manage exceptions](https://www.elastic.co/docs/solutions/security/detect-and-alert/add-manage-exceptions).
![An exception item](https://www.elastic.co/docs/solutions/images/security-exception-item-example.png)

<note>
  You can also use [value lists](https://www.elastic.co/docs/solutions/security/detect-and-alert/create-manage-value-lists) to define exceptions for detection rules. Value lists allow you to match an exception against a list of possible values.
</note>


## Exceptions shared among multiple rules

If you want an exception to apply to multiple rules, you can add an exception to a shared exception list. Shared exception lists allow you to group exceptions together and then associate them with multiple rules. Refer to [Create and manage shared exception lists](https://www.elastic.co/docs/solutions/security/detect-and-alert/create-manage-shared-exception-lists) to learn more.
![Shared Exception Lists page](https://www.elastic.co/docs/solutions/images/security-rule-exceptions-page.png)