﻿---
title: Reduce notifications and alerts
description: Elastic Security offers several features to help reduce the number of notifications and alerts generated by your detection rules. This table provides...
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/reduce-notifications-alerts
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Reduce notifications and alerts
Elastic Security offers several features to help reduce the number of notifications and alerts generated by your detection rules. This table provides a general comparison of these features, with links for more details:

|                                                                                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
|----------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Rule action snoozing](/docs/solutions/security/detect-and-alert/manage-detection-rules#snooze-rule-actions)   | **Stops a specific rule’s notification actions from running**.Use to avoid unnecessary notifications from a specific rule. The rule continues to run and generate alerts during the snooze period, but its [notification actions](/docs/solutions/security/detect-and-alert/create-detection-rule#rule-response-action) don’t run.                                                                                                                                                 |
| [Maintenance window](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/maintenance-windows)      | **Prevents all rules' notification actions from running**.Use to avoid false alarms and unnecessary notifications during planned outages. All rules continue to run and generate alerts during the maintenance window, but their [notification actions](/docs/solutions/security/detect-and-alert/create-detection-rule#rule-notifications) don’t run. **Note**: Maintenance windows are a Kibana feature, configured outside of the Elastic Security app in **Stack Management**. |
| [Alert suppression](https://www.elastic.co/docs/solutions/security/detect-and-alert/suppress-detection-alerts) | **Reduces repeated or duplicate alerts**.Use to reduce the number of alerts created when a rule meets its criteria repeatedly. Duplicate qualifying events are grouped, and only one alert is created for each group.                                                                                                                                                                                                                                                              |
| [Rule exception](https://www.elastic.co/docs/solutions/security/detect-and-alert/rule-exceptions)              | **Prevents a rule from creating alerts under specific conditions**.Use to reduce false positive alerts by preventing trusted processes and network activity from generating unnecessary alerts. You can configure an exception to be used by a single rule or shared among multiple rules, but they typically don’t affect *all* rules.                                                                                                                                            |