﻿---
title: Query alert indices
description: This page explains how you should query alert indices, for example, when building rule queries, custom dashboards, or visualizations. For more information...
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/query-alert-indices
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Query alert indices
This page explains how you should query alert indices, for example, when building rule queries, custom dashboards, or visualizations. For more information about alert event field definitions, review the [Alert schema](https://www.elastic.co/docs/reference/security/fields-and-object-schemas/alert-schema).
<important>
  System indices, such as the alert indices, contain important configuration and internal data; do not change their mappings. Changes can lead to rule execution and alert indexing failures. Use [runtime fields](https://www.elastic.co/docs/solutions/security/get-started/create-runtime-fields-in-elastic-security) instead, which allow you to add fields to existing alert and event documents.
</important>


## Alert index aliases

We recommend querying the following index aliases:
We recommend querying the `.alerts-security.alerts-<space-id>` index alias. You should not include a dash or wildcard after the space ID. To query all spaces, use the following syntax: `.alerts-security.alerts-*`.

## Alert indices

For additional context, alert events are stored in hidden Elasticsearch indices. We do not recommend querying them directly. The naming convention for these indices and their aliases is `.internal.alerts-security.alerts-<space-id>-NNNNNN`, where `NNNNNN` is a number that increases over time, starting from 000001.