﻿---
title: Exclude cold and frozen data from individual rules
description: Your rule might perform slower or fail if it queries data from cold or frozen data tiers. To help Elasticsearch exclude cold and frozen data more efficiently,...
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/exclude-cold-frozen-data-from-individual-rules
products:
  - Elastic Security
applies_to:
  - Elastic Stack: Generally available
---

# Exclude cold and frozen data from individual rules
Your rule might perform slower or fail if it queries data from cold or frozen [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers). To help Elasticsearch exclude cold and frozen data more efficiently, apply a Query DSL filter that ignores cold and frozen documents when your rule executes. You can add the filter when creating a new rule or updating an existing one.
<tip>
  To ensure that rules in your Kibana space exclude cold and frozen documents when executing, configure the `excludedDataTiersForRuleExecution` [advanced setting](/docs/solutions/security/get-started/configure-advanced-settings#exclude-cold-frozen-data-rule-executions). This setting does not apply to machine learning rules.
</tip>

<important>
  - This method is not supported for ES|QL and machine learning rules.
  - Even when applying this filter, indicator match and event correlation rules may still fail if a frozen or cold shard that matches the rule’s specified index pattern is unavailable during rule executions. If failures occur, we recommend modifying the rule’s index patterns to only match indices containing hot tier data.
</important>

Here is a sample Query DSL filter that excludes frozen tier documents during rule execution:
```json
{
   "bool":{
      "must_not":{
         "terms":{
            "_tier":[
               "data_frozen"
            ]
         }
      }
   }
}
```

Here is another sample Query DSL filter that excludes cold and frozen tier documents during rule execution:
```json
{
   "bool":{
      "must_not":{
         "terms":{
            "_tier":[
               "data_frozen", "data_cold"
            ]
         }
      }
   }
}
```