﻿---
title: Turn on detections
description: Learn how to configure and enable the Detections feature in Elastic Security for your deployment type.
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-requirements
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Turn on detections
Before you can create rules, manage alerts, or use other [detection capabilities](https://www.elastic.co/docs/solutions/security/detect-and-alert), you need to enable the Detections feature. This page walks you through the required setup for your deployment type and shows you how to turn on detections.
<tab-set>
  <tab-item title="Elastic Cloud Serverless">
    The detections feature is turned on by default in Serverless projects. Your access level depends on your assigned role.

    | Access level                                   | Roles                                                                  |
    |------------------------------------------------|------------------------------------------------------------------------|
    | Full access (manage rules, alerts, exceptions) | Editor, SOC Manager, Detections Eng, Tier 3 Analyst, Platform Engineer |
    | Read-only (only view rules and alerts)         | Viewer, Tier 1 Analyst, Tier 2 Analyst                                 |
    Refer to [Predefined roles](/docs/solutions/security/detect-and-alert/detections-privileges#predefined-serverless-roles-detections) for a list of predefined roles with detection privileges.
  </tab-item>

  <tab-item title="Elastic Cloud">
    The detection engine initializes automatically when a user with [sufficient privileges](https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-privileges) visits the **Rules** page. To open the page, find **Detection rules (SIEM)** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).No additional configuration is required.
  </tab-item>

  <tab-item title="Self-managed Elastic Stack">
    Complete these steps to turn on the detections feature in your space.
    <stepper>
      <step title="Enable HTTPS">
        Configure HTTPS for communication between [Elasticsearch and Kibana](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-http).
      </step>

      <step title="Configure {{kib}}">
        In your [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file, add an encryption key with at least 32 alphanumeric characters:
        ```yaml
        xpack.encryptedSavedObjects.encryptionKey: 'fhjskloppd678ehkdfdlliverpoolfcr'
        ```

        <important>
          After changing the encryption key and restarting Kibana, you must restart all detection rules.
        </important>
      </step>

      <step title="Configure {{es}}">
        In your [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) file:
        1. Set `xpack.security.enabled` to `true`. Refer to [General security settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#general-security-settings) for more information.
        2. Ensure `search.allow_expensive_queries` is `true` (the default). If it's set to `false`, remove that setting.
      </step>

      <step title="Enable detections">
        1. Go to the **Rules** page. Find **Detection rules (SIEM)** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
        2. The detection engine initializes when a user with [sufficient privileges](https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-privileges) visits the page.

        <note>
          To enable detections in multiple spaces, visit the **Rules** page in each space.
        </note>
      </step>
    </stepper>
  </tab-item>
</tab-set>


## Start detecting threats

With detections enabled, you're ready to create rules and start responding to threats. Do the following:
- **Add detection rules**
  - [Install Elastic prebuilt rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/install-manage-elastic-prebuilt-rules): Get started quickly with hundreds of rules that detect common threats
- [Create custom rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/create-detection-rule): Write rules tailored to your environment
- [Configure anomaly detection rules](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/machine-learning-job-rule-requirements): Use machine learning to detect unusual behavior
- **Respond to and manage alerts**
  - [Manage detection alerts](https://www.elastic.co/docs/solutions/security/detect-and-alert/manage-detection-alerts): Triage, investigate, and resolve alerts
- [Set up alert notifications](/docs/solutions/security/detect-and-alert/create-detection-rule#rule-notifications): Send alerts to external systems like Slack, email, or ticketing tools
- [Tune rules to reduce noise](https://www.elastic.co/docs/solutions/security/detect-and-alert/tune-detection-rules): Add exceptions and adjust rules to minimize false positives

<tip>
  For a complete walkthrough, check out [Quickstart: Detect and respond to threats with SIEM](https://www.elastic.co/docs/solutions/security/get-started/get-started-detect-with-siem).
</tip>