﻿---
title: Detections privileges
description: Find privilege requirements, predefined roles, and the authorization model for Elastic Security detection features.
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-privileges
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Detections privileges
Learn about the access requirements for detection features, including:
- **Privilege requirements**: Cluster, index, and Kibana privileges that your role needs to enable detections, manage rules, and more
- **Predefined roles**: Elastic Cloud Serverless roles with detection privileges
- **Authorization model**: How detection rules use API keys to run background tasks

For instructions on turning on the detections feature, refer to [Turn on detections](https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-requirements).

## About index privileges

When creating custom roles for detection features, you'll need to grant access to system indices that include your space ID (`<space-id>`). For example, the default space uses `.alerts-security.alerts-default`. Refer to the following details to understand which system indices your role might require access to.
<tab-set>
  <tab-item title="Elastic Cloud Serverless">
    Only uses the `.alerts-security.alerts-<space-id>` index.
  </tab-item>

  <tab-item title="Elastic Cloud Hosted">
    Uses the `.alerts-security.alerts-<space-id>` index. If you upgraded from version 8.0 or earlier, you might also need privileges on the legacy `.siem-signals-<space-id>` index.
  </tab-item>
</tab-set>


## Enable the detections feature

Required to initialize the detection engine in a Kibana space.
<definitions>
  <definition term="Cluster privileges">
    `manage`
  </definition>
  <definition term="Index privileges">
    `manage`, `write`, `read`, `view_index_metadata` on:
    - `.alerts-security.alerts-<space-id>`
    - `.siem-signals-<space-id>` (only if you upgraded from version 8.0 or earlier)
    - `.lists-<space-id>`
    - `.items-<space-id>`
  </definition>
  <definition term="Kibana privileges">
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `All` for the `Rules, Alerts, and Exceptions` feature
    - <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> `All` for the `Security` feature
  </definition>
</definitions>


## Preview rules

<definitions>
  <definition term="Cluster privileges">
    None
  </definition>
  <definition term="Index privileges">
    `read` on:
    - `.preview.alerts-security.alerts-<space-id>`
    - `.internal.preview.alerts-security.alerts-<space-id>-*`
  </definition>
  <definition term="Kibana privileges">
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `All` for the `Rules, Alerts, and Exceptions` feature
    - <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> `All` for the `Security` feature
  </definition>
</definitions>


## Manage rules

<definitions>
  <definition term="Cluster privileges">
    None
  </definition>
  <definition term="Index privileges">
    `manage`, `write`, `read`, `view_index_metadata` on:
    - `.alerts-security.alerts-<space-id>`
    - `.siem-signals-<space-id>` (only if you upgraded from version 8.0 or earlier)
    - `.lists-<space-id>`
    - `.items-<space-id>`
  </definition>
  <definition term="Kibana privileges">
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `All` for the `Rules, Alerts, and Exceptions` feature
    - <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> `All` for the `Security` feature
  </definition>
</definitions>

<note>
  To manage rules with actions and connectors, you need additional privileges for the `Actions and Connectors` feature (`Management`> `Actions and Connectors`):
  - `All`: Provides full access to rule actions and connectors.
  - `Read`: Allows you to edit rule actions and use existing connectors, but you cannot create new connectors.
  To import rules with actions, you need at least `Read` privileges. To overwrite or add new connectors during import, you need `All` privileges.
</note>


## Manage alerts

Allows you to manage alerts.
<definitions>
  <definition term="Cluster privileges">
    None
  </definition>
  <definition term="Index privileges">
    `maintenance`, `write`, `read`, `view_index_metadata` on:
    - `.alerts-security.alerts-<space-id>`
    - `.internal.alerts-security.alerts-<space-id>-*`
    - `.siem-signals-<space-id>` (only if you upgraded from version 8.0 or earlier)
    - `.lists-<space-id>`
    - `.items-<space-id>`
  </definition>
  <definition term="Kibana privileges">
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `All` for the `Rules, Alerts, and Exceptions` feature
    - <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> `All` for the `Security` feature
  </definition>
</definitions>

<note>
  Alerts are managed through Elasticsearch index privileges. To view alert management flows, you need at least `Read` for the `Rules, Alerts, and Exceptions` feature.Before a user can be assigned to a case, they must log into Kibana at least once to create a user profile.
</note>


## Manage exceptions

<definitions>
  <definition term="Cluster privileges">
    None
  </definition>
  <definition term="Index privileges">
    None
  </definition>
  <definition term="Kibana privileges">
    - <applies-to>Elastic Stack: Planned</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> At least `Read` for the `Rules, Alerts, and Exceptions` feature and **Manage Exceptions** selected for the `Exceptions` sub-feature
    - <applies-to>Elastic Stack: Generally available in 9.3</applies-to> `All` for the `Rules, Alerts, and Exceptions` feature
    - <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> `All` for the `Security` feature
  </definition>
</definitions>


## Manage value lists

<definitions>
  <definition term="Cluster privileges">
    `manage`
  </definition>
  <definition term="Index privileges">
    `manage`, `write`, `read`, `view_index_metadata` on:
    - `.lists-<space-id>`
    - `.items-<space-id>`
  </definition>
  <definition term="Kibana privileges">
    - <applies-to>Elastic Stack: Generally available since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `All` for the `Rules, Alerts, and Exceptions` feature
    - <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> `All` for the `Security` feature
  </definition>
</definitions>

<important>
  To create the `.lists` and `.items` data streams in your space, visit the **Rules** page for each appropriate space.
</important>


## Predefined Elastic Cloud Serverless roles

<applies-to>
  - Elastic Cloud Serverless: Generally available
</applies-to>

Elastic Cloud Serverless includes predefined roles with detection privileges:

| Action                                      | Roles with access                                                                                                            |
|---------------------------------------------|------------------------------------------------------------------------------------------------------------------------------|
| Manage rules                                | Threat Intelligence Analyst, Tier 3 Analyst, Detections Eng, SOC Manager, Endpoint Policy Manager, Platform Engineer, Editor |
| View rules (read only)                      | Tier 1 Analyst, Tier 2 Analyst, Viewer, Endpoint Operations Analyst                                                          |
| Manage alerts                               | All roles except Viewer                                                                                                      |
| Manage exceptions and value lists           | Threat Intelligence Analyst, Tier 3 Analyst, Detections Eng, SOC Manager, Endpoint Policy Manager, Platform Engineer, Editor |
| View exceptions and value lists (read only) | Tier 1 Analyst, Tier 2 Analyst, Viewer, Endpoint Operations Analyst                                                          |


## Authorization

<applies-to>
  - Elastic Stack: Generally available since 9.0
</applies-to>

Detection rules, including all background detection checks and the actions they generate, are authorized using an [API key](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) associated with the last user to edit the rule. When a rule is created or modified, an API key is generated that captures a snapshot of that user's privileges. This API key is used to run all background tasks associated with the rule, including detection checks and executing actions.
<important>
  If a rule requires certain privileges to run (such as index privileges), and a user without those privileges updates the rule, the rule will no longer function.
</important>