﻿---
title: About detection rules
description: Rules run periodically and search for source events, matches, sequences, or machine learning job anomaly results that meet their criteria. When a rule’s...
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# About detection rules
Rules run periodically and search for source events, matches, sequences, or machine learning job anomaly results that meet their criteria. When a rule’s criteria are met, a detection alert is created.

## Rule types

You can create the following types of rules:
- [**Custom query**](/docs/solutions/security/detect-and-alert/create-detection-rule#create-custom-rule): Query-based rule, which searches the defined indices and creates an alert when one or more documents match the rule’s query.
- [**Machine learning**](/docs/solutions/security/detect-and-alert/create-detection-rule#create-ml-rule): Machine learning rule, which creates an alert when a machine learning job discovers an anomaly above the defined threshold (see [Anomaly detection](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/anomaly-detection)).
  For machine learning rules, the associated machine learning job must be running. If the machine learning job isn’t running, the rule will:
  - Run and create alerts if existing anomaly results with scores above the defined threshold are discovered.
- Issue an error stating the machine learning job was not running when the rule executed.
- [**Threshold**](/docs/solutions/security/detect-and-alert/create-detection-rule#create-threshold-rule): Searches the defined indices and creates a detections alert when the number of times the specified field’s value is present and meets the threshold during a single execution. When multiple values meet the threshold, an alert is generated for each value.
  For example, if the threshold `field` is `source.ip` and its `value` is `10`, an alert is generated for every source IP address that appears in at least 10 of the rule’s search results.
- [**Event correlation**](/docs/solutions/security/detect-and-alert/create-detection-rule#create-eql-rule): Searches the defined indices and creates an alert when results match an [Event Query Language (EQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/eql) query.
- [**Indicator match**](/docs/solutions/security/detect-and-alert/create-detection-rule#create-indicator-rule): Creates an alert when Elastic Security index field values match field values defined in the specified indicator index patterns. For example, you can create an indicator index for IP addresses and use this index to create an alert whenever an event’s `destination.ip` equals a value in the index. Indicator index field mappings should be [ECS-compliant](https://www.elastic.co/docs/reference/ecs). For information on creating Elasticsearch indices and field types, see [Index some documents](https://www.elastic.co/docs/manage-data/ingest), [Create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create), and [Field data types](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types). If you have indicators in a standard file format, such as CSV or JSON, you can also use the Machine Learning Data Visualizer to import your indicators into an indicator index. See [Explore the data in Kibana](/docs/explore-analyze/machine-learning/anomaly-detection/ml-getting-started#sample-data-visualizer) and use the **Import Data** option to import your indicators.
  <tip>
  You can also use value lists as the indicator match index. See [Use value lists with indicator match rules](/docs/solutions/security/detect-and-alert/create-detection-rule#indicator-value-lists) at the end of this topic for more information.
  </tip>
- [**New terms**](/docs/solutions/security/detect-and-alert/create-detection-rule#create-new-terms-rule): Generates an alert for each new term detected in source documents within a specified time range. You can also detect a combination of up to three new terms (for example, a `host.ip` and `host.id` that have never been observed together before).
- [**ES|QL**](/docs/solutions/security/detect-and-alert/create-detection-rule#create-esql-rule): Searches the defined indices and creates an alert when results match an [Elasticsearch Query Language ES|QL](https://www.elastic.co/docs/reference/query-languages/esql) query.
  <note>
  ES|QL is enabled by default in Kibana. It can be disabled using the `enableESQL` setting from the [Advanced Settings](https://www.elastic.co/docs/reference/kibana/advanced-settings). This will hide the ES|QL user interface from various applications. However, users will be able to access existing ES|QL artifacts like saved searches and visualizations.
  </note>

![Shows the Rules page](https://www.elastic.co/docs/solutions/images/security-all-rules.png)


## Data views and index patterns

When you create a rule, you must either specify the Elasticsearch index pattens for which you’d like the rule to run, or select a [data view field](https://www.elastic.co/docs/solutions/security/get-started/data-views-elastic-security) as the data source. If you select a data view, you can select [runtime fields](https://www.elastic.co/docs/solutions/security/get-started/create-runtime-fields-in-elastic-security) associated with that data view to create a query for the rule (with the exception of machine learning rules, which do not use queries).
<note>
  To access data views in Elastic Stack, you must have the [required permissions](/docs/explore-analyze/find-and-organize/data-views#data-views-read-only-access). To access them in Serverless, you must have the appropriate [predefined Security user role](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles) or a [custom role](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) with the right privileges.
</note>

<important>
  System indices, such as the alert indices, contain important configuration and internal data; do not change their mappings. Changes can lead to rule execution and alert indexing failures. Use [runtime fields](https://www.elastic.co/docs/solutions/security/get-started/create-runtime-fields-in-elastic-security) instead, which allow you to add fields to existing alert and event documents.
</important>


## Notifications

For both prebuilt and custom rules, you can send notifications when alerts are created. Notifications can be sent via Jira, Microsoft Teams, PagerDuty, Slack, and others, and can be configured when you create or edit a rule.

## Authorization

Rules, including all background detection and the actions they generate, are authorized using an [API key](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) associated with the last user to edit the rule. Upon creating or modifying a rule, an API key is generated for that user, capturing a snapshot of their privileges. The API key is then used to run all background tasks associated with the rule including detection checks and executing actions.
<important>
  If a rule requires certain privileges to run, such as index privileges, keep in mind that if a user without those privileges updates the rule, the rule will no longer function.
</important>


## Exceptions

When modifying rules or managing detection alerts, you can [add exceptions](https://www.elastic.co/docs/solutions/security/detect-and-alert/add-manage-exceptions) that prevent a rule from generating alerts even when its criteria are met. This is useful for reducing noise, such as preventing alerts from trusted processes and internal IP addresses.
<note>
  You can add exceptions to custom query, machine learning, event correlation, and indicator match rule types.
</note>