﻿---
title: About building block rules
description: Create building block rules when you do not want to see their generated alerts in the UI. This is useful when you want: A record of low-risk alerts without...
url: https://www.elastic.co/docs/solutions/security/detect-and-alert/about-building-block-rules
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# About building block rules
Create building block rules when you do not want to see their generated alerts in the UI. This is useful when you want:
- A record of low-risk alerts without producing noise in the Alerts table.
- Rules that execute on the alert indices (`.alerts-security.alerts-<kibana space>`). You can then use building block rules to create hidden alerts that act as a basis for an *ordinary* rule to generate visible alerts.

<tip>
  Add [rule notifications](/docs/solutions/security/detect-and-alert/create-detection-rule#rule-notifications) to building block rules to notify you when building block alerts are generated.
</tip>


## Set up rules that run on alert indices

To create a rule that searches alert indices, select **Index Patterns** as the rule’s **Source** and enter the index pattern for alert indices (`.alerts-security.alerts-*`):
![alert indices ui](https://www.elastic.co/docs/solutions/images/security-alert-indices-ui.png)


## View building block alerts in the UI

By default, building block alerts are excluded from the Overview and Alerts pages. You can choose to include building block alerts on the Alerts page, which expands the number of alerts.
1. Find **Alerts** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. In the Alerts table, select **Additional filters** → **Include building block alerts**, located on the far-right.

<note>
  On a building block rule details page, the rule’s alerts are displayed (by default, **Include building block alerts** is selected).
</note>