﻿---
title: Overview dashboard
description: The Overview dashboard provides a high-level snapshot of alerts and events. It helps you assess overall system health and find anomalies that may require...
url: https://www.elastic.co/docs/solutions/security/dashboards/overview-dashboard
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Overview dashboard
The Overview dashboard provides a high-level snapshot of alerts and events. It helps you assess overall system health and find anomalies that may require further investigation.
![Overview dashboard](https://www.elastic.co/docs/solutions/images/security-overview-pg.png)


## Live feed

The live feed on the Overview dashboard helps you quickly access recently created cases, favorited Timelines, and the latest Elastic Security news.
<tip>
  The **Security news** section provides the latest Elastic Security news to help you stay informed of new developments, learn about Elastic Security features, and more.
</tip>

![Overview dashboard with live feed section highlighted](https://www.elastic.co/docs/solutions/images/security-live-feed-ov-page.png)


## Histograms

Time-based histograms show the number of detections, alerts, and events that have occurred within the selected time range. To focus on a particular time, click and drag to select a time range, or choose a preset value. The **Stack by** menu lets you select which field is used to organize the data. For example, in the Alert trend histogram, stack by `kibana.alert.rule.name` to display alert counts by rule name within the specified time frame.
Hover over histograms, graphs, and tables to display an **Inspect** button (![Inspect icon](https://www.elastic.co/docs/solutions/images/security-inspect-icon.png "title")) or options menu (![Three-dot menu icon](https://www.elastic.co/docs/solutions/images/security-three-dot-icon.png "title")). Click to inspect the visualization’s Elasticsearch queries, add it to a new or existing case, or open it in Lens for customization.

## Host and network events

View event and host counts grouped by data source, such as **Auditbeat** or **Elastic Defend**. Expand a category to view specific counts of host or network events from the selected source.
![Host and network events on the Overview dashboard](https://www.elastic.co/docs/solutions/images/security-events-count.png)


## Threat Intelligence

The Threat Intelligence view on the Overview dashboard provides streamlined threat intelligence data for threat detection and matching.
The view shows the total number of ingested threat indicators, enabled threat intelligence sources, and ingested threat indicators per source. To learn more about the ingested indicator data, click **View indicators**.
<note>
  For more information about connecting to threat intelligence sources, visit [Enable threat intelligence integrations](https://www.elastic.co/docs/solutions/security/get-started/enable-threat-intelligence-integrations).
</note>

![threat intelligence view](https://www.elastic.co/docs/solutions/images/security-threat-intelligence-view.png)